/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.database.internal;

import com.openexchange.database.ConfigDatabaseService;
import com.openexchange.database.DBPoolingExceptionCodes;
import com.openexchange.database.internal.AssignmentImpl;
import com.openexchange.database.internal.ConfigDatabaseAssignmentService;
import com.openexchange.database.internal.Pools;
import com.openexchange.database.internal.ReplicationMonitor;
import com.openexchange.database.internal.Server;
import com.openexchange.exception.OXException;
import com.openexchange.java.Autoboxing;
import com.openexchange.log.ForceLog;
import com.openexchange.log.LogFactory;
import com.openexchange.log.LogProperties;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;

public final class ConfigDatabaseServiceImpl
implements ConfigDatabaseService {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(ConfigDatabaseServiceImpl.class));
    private final Pools pools;
    private final ConfigDatabaseAssignmentService assignmentService;

    ConfigDatabaseServiceImpl(ConfigDatabaseAssignmentService assignmentService, Pools pools) {
        this.assignmentService = assignmentService;
        this.pools = pools;
    }

    private Connection get(boolean write) throws OXException {
        AssignmentImpl assign = this.assignmentService.getConfigDBAssignment();
        LogProperties.putLogProperty((LogProperties.Name)LogProperties.Name.DATABASE_SCHEMA, (Object)ForceLog.valueOf((Object)"configdb"));
        return ReplicationMonitor.checkFallback(this.pools, assign, false, write);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void back(Connection con) {
        if (null == con) {
            LogProperties.putLogProperty((LogProperties.Name)LogProperties.Name.DATABASE_SCHEMA, null);
            OXException e = DBPoolingExceptionCodes.NULL_CONNECTION.create();
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return;
        }
        try {
            con.close();
        }
        catch (SQLException e) {
            OXException e1 = DBPoolingExceptionCodes.SQL_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            LOG.error((Object)e1.getMessage(), (Throwable)e1);
        }
        finally {
            LogProperties.putLogProperty((LogProperties.Name)LogProperties.Name.DATABASE_SCHEMA, null);
        }
    }

    public Connection getReadOnly() throws OXException {
        return this.get(false);
    }

    public Connection getWritable() throws OXException {
        return this.get(true);
    }

    public void backReadOnly(Connection con) {
        ConfigDatabaseServiceImpl.back(con);
    }

    public void backWritable(Connection con) {
        ConfigDatabaseServiceImpl.back(con);
    }

    public int[] listContexts(int poolId) throws OXException {
        ArrayList<Integer> tmp = new ArrayList<Integer>();
        Connection con = this.getReadOnly();
        String getcid = "SELECT cid FROM context_server2db_pool WHERE read_db_pool_id=? OR write_db_pool_id=?";
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement("SELECT cid FROM context_server2db_pool WHERE read_db_pool_id=? OR write_db_pool_id=?");
            stmt.setInt(1, poolId);
            stmt.setInt(2, poolId);
            result = stmt.executeQuery();
            while (result.next()) {
                tmp.add(Autoboxing.I((int)result.getInt(1)));
            }
        }
        catch (SQLException e) {
            try {
                throw DBPoolingExceptionCodes.SQL_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                this.backReadOnly(con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        this.backReadOnly(con);
        int[] retval = new int[tmp.size()];
        for (int i = 0; i < tmp.size(); ++i) {
            retval[i] = (Integer)tmp.get(i);
        }
        return retval;
    }

    public int getServerId() throws OXException {
        return Server.getServerId();
    }
}

