/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.api2;

import com.openexchange.api2.MailInterfaceMonitorMBean;
import com.openexchange.mail.api.MailAccess;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class MailInterfaceMonitor
implements MailInterfaceMonitorMBean {
    private static final int USE_TIME_COUNT = 1000;
    private final long[] avgUseTimeArr;
    private int avgUseTimePointer;
    private long maxUseTime;
    private long minUseTime = Long.MAX_VALUE;
    private final AtomicInteger numBrokenConnections = new AtomicInteger();
    private final AtomicInteger numTimeoutConnections = new AtomicInteger();
    private final AtomicInteger numSuccessfulLogins = new AtomicInteger();
    private final AtomicInteger numFailedLogins = new AtomicInteger();
    private final Lock useTimeLock = new ReentrantLock();
    private final Map<String, Integer> unsupportedEnc;

    public MailInterfaceMonitor() {
        this.avgUseTimeArr = new long[1000];
        this.unsupportedEnc = new ConcurrentHashMap<String, Integer>();
    }

    @Override
    public int getNumActive() {
        return MailAccess.getCounter();
    }

    public void changeNumActive(boolean increment) {
    }

    @Override
    public double getAvgUseTime() {
        long duration = 0L;
        for (int i = 0; i < this.avgUseTimeArr.length; ++i) {
            duration += this.avgUseTimeArr[i];
        }
        return (double)duration / (double)this.avgUseTimeArr.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUseTime(long time) {
        if (this.useTimeLock.tryLock()) {
            try {
                this.avgUseTimeArr[this.avgUseTimePointer++] = time;
                this.avgUseTimePointer %= this.avgUseTimeArr.length;
                this.setMaxUseTime(time);
                this.setMinUseTime(time);
            }
            finally {
                this.useTimeLock.unlock();
            }
        }
    }

    @Override
    public long getMaxUseTime() {
        return this.maxUseTime;
    }

    private final void setMaxUseTime(long maxUseTime) {
        this.maxUseTime = Math.max(maxUseTime, this.maxUseTime);
    }

    @Override
    public void resetMaxUseTime() {
        this.maxUseTime = 0L;
    }

    @Override
    public long getMinUseTime() {
        return this.minUseTime;
    }

    private final void setMinUseTime(long minUseTime) {
        this.minUseTime = Math.min(minUseTime, this.minUseTime);
    }

    @Override
    public void resetMinUseTime() {
        this.minUseTime = Long.MAX_VALUE;
    }

    @Override
    public int getNumBrokenConnections() {
        return this.numBrokenConnections.get();
    }

    public void changeNumBrokenConnections(boolean increment) {
        if (increment) {
            this.numBrokenConnections.incrementAndGet();
        } else {
            this.numBrokenConnections.decrementAndGet();
        }
    }

    @Override
    public int getNumTimeoutConnections() {
        return this.numTimeoutConnections.get();
    }

    public void changeNumTimeoutConnections(boolean increment) {
        if (increment) {
            this.numTimeoutConnections.incrementAndGet();
        } else {
            this.numTimeoutConnections.decrementAndGet();
        }
    }

    @Override
    public int getNumSuccessfulLogins() {
        return this.numSuccessfulLogins.get();
    }

    public void changeNumSuccessfulLogins(boolean increment) {
        if (increment) {
            this.numSuccessfulLogins.incrementAndGet();
        } else {
            this.numSuccessfulLogins.decrementAndGet();
        }
    }

    @Override
    public int getNumFailedLogins() {
        return this.numFailedLogins.get();
    }

    public void changeNumFailedLogins(boolean increment) {
        if (increment) {
            this.numFailedLogins.incrementAndGet();
        } else {
            this.numFailedLogins.decrementAndGet();
        }
    }

    @Override
    public void resetNumBrokenConnections() {
        this.numBrokenConnections.set(0);
    }

    @Override
    public void resetNumTimeoutConnections() {
        this.numTimeoutConnections.set(0);
    }

    @Override
    public void resetNumSuccessfulLogins() {
        this.numSuccessfulLogins.set(0);
    }

    @Override
    public void resetNumFailedLogins() {
        this.numFailedLogins.set(0);
    }

    @Override
    public String getUnsupportedEncodingExceptions() {
        int size = this.unsupportedEnc.size();
        if (size == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(100);
        Iterator<Map.Entry<String, Integer>> iter = this.unsupportedEnc.entrySet().iterator();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            Map.Entry<String, Integer> entry = iter.next();
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append(" times");
        }
        return sb.toString();
    }

    public void addUnsupportedEncodingExceptions(String encoding) {
        String key = encoding.toLowerCase(Locale.ENGLISH);
        Integer num = this.unsupportedEnc.get(key);
        if (null == num) {
            this.unsupportedEnc.put(key, 1);
        } else {
            this.unsupportedEnc.put(key, num + 1);
        }
    }
}

