/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.responseRenderers;

import com.openexchange.ajax.container.FileHolder;
import com.openexchange.ajax.container.IFileHolder;
import com.openexchange.ajax.helper.DownloadUtility;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.ResponseRenderer;
import com.openexchange.ajax.requesthandler.Utils;
import com.openexchange.exception.Log;
import com.openexchange.exception.OXException;
import com.openexchange.java.Streams;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.tools.images.ImageTransformationService;
import com.openexchange.tools.images.ImageTransformations;
import com.openexchange.tools.images.ScaleType;
import com.openexchange.tools.servlet.http.Tools;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FileResponseRenderer
implements ResponseRenderer {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(FileResponseRenderer.class));
    private static final int BUFLEN = 2048;
    private static final String PARAMETER_CONTENT_DISPOSITION = "content_disposition";
    private static final String PARAMETER_CONTENT_TYPE = "content_type";
    private static final String SAVE_AS_TYPE = "application/octet-stream";
    private volatile ImageTransformationService scaler;
    private static final String DELIVERY = "delivery";
    private static final String DOWNLOAD = "download";
    private static final String VIEW = "view";

    @Override
    public int getRanking() {
        return 0;
    }

    public void setScaler(ImageTransformationService scaler) {
        this.scaler = scaler;
    }

    @Override
    public boolean handles(AJAXRequestData request, AJAXRequestResult result) {
        return result.getResultObject() instanceof IFileHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void write(AJAXRequestData request, AJAXRequestResult result, HttpServletRequest req, HttpServletResponse resp) {
        InputStream documentData;
        IFileHolder file;
        block30: {
            block29: {
                String contentDisposition;
                String delivery;
                file = (IFileHolder)result.getResultObject();
                String fileContentType = file.getContentType();
                String fileName = file.getName();
                String contentType = req.getParameter(PARAMETER_CONTENT_TYPE);
                if (null == contentType) {
                    contentType = fileContentType;
                }
                if ((delivery = req.getParameter(DELIVERY)) == null) {
                    delivery = file.getDelivery();
                }
                contentDisposition = null == (contentDisposition = req.getParameter(PARAMETER_CONTENT_DISPOSITION)) ? file.getDisposition() : Utils.encodeUrl(contentDisposition);
                documentData = null;
                try {
                    int read;
                    file = this.transformIfImage(request, file, delivery);
                    if (null == file) {
                        resp.sendError(404, "Image not found.");
                        return;
                    }
                    InputStream inputStream = documentData = null == file.getStream() ? null : new BufferedInputStream(file.getStream());
                    if (null == documentData) {
                        resp.sendError(404, "Image not found.");
                        Streams.close((Closeable)file);
                        break block29;
                    }
                    String userAgent = req.getHeader("user-agent");
                    if (SAVE_AS_TYPE.equals(contentType) || DOWNLOAD.equalsIgnoreCase(delivery)) {
                        StringBuilder sb = new StringBuilder(32);
                        sb.append(this.isEmpty(contentDisposition) ? "attachment" : this.checkedContentDisposition(contentDisposition.trim(), file));
                        DownloadUtility.appendFilenameParameter(file.getName(), null, userAgent, sb);
                        resp.setHeader("Content-Disposition", sb.toString());
                        resp.setContentType(null == contentType ? SAVE_AS_TYPE : contentType);
                    } else {
                        DownloadUtility.CheckedDownload checkedDownload = DownloadUtility.checkInlineDownload(documentData, fileName, fileContentType, contentDisposition, userAgent);
                        if (delivery == null || !delivery.equalsIgnoreCase(VIEW)) {
                            if (this.isEmpty(contentDisposition)) {
                                resp.setHeader("Content-Disposition", checkedDownload.getContentDisposition());
                            } else if (contentDisposition.indexOf(59) >= 0) {
                                resp.setHeader("Content-Disposition", contentDisposition.trim());
                            } else {
                                String disposition = checkedDownload.getContentDisposition();
                                int pos = disposition.indexOf(59);
                                if (pos >= 0) {
                                    resp.setHeader("Content-Disposition", contentDisposition.trim() + disposition.substring(pos));
                                } else {
                                    resp.setHeader("Content-Disposition", contentDisposition.trim());
                                }
                            }
                        }
                        if (contentType == null) {
                            resp.setContentType(checkedDownload.getContentType());
                        } else {
                            resp.setContentType(contentType);
                        }
                        documentData = checkedDownload.getInputStream();
                    }
                    Tools.removeCachingHeader(resp);
                    if (delivery == null || !delivery.equalsIgnoreCase(DOWNLOAD)) {
                        String eTag = result.getHeader("ETag");
                        if (null != eTag) {
                            long expires = result.getExpires();
                            Tools.setETag(eTag, expires > 0L ? new Date(System.currentTimeMillis() + expires) : null, resp);
                        } else {
                            long expires = result.getExpires();
                            if (expires < 0L) {
                                Tools.setExpiresInOneYear(resp);
                            } else if (expires > 0L) {
                                Tools.setExpires(new Date(System.currentTimeMillis() + expires), resp);
                            }
                        }
                    }
                    ServletOutputStream outputStream = resp.getOutputStream();
                    int len = 2048;
                    byte[] buf = new byte[2048];
                    while ((read = documentData.read(buf, 0, 2048)) > 0) {
                        outputStream.write(buf, 0, read);
                    }
                    outputStream.flush();
                    Streams.close((Closeable)file);
                    break block30;
                }
                catch (Exception e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                    return;
                }
            }
            Streams.close((Closeable)documentData);
            return;
        }
        Streams.close((Closeable)documentData);
        return;
        finally {
            Streams.close((Closeable)file);
            Streams.close(documentData);
        }
    }

    private IFileHolder transformIfImage(AJAXRequestData request, IFileHolder file, String delivery) throws IOException, OXException {
        InputStream transformed;
        Boolean compress;
        Boolean rotate;
        boolean markSupported;
        if (null == this.scaler || !this.isImage(file)) {
            return file;
        }
        InputStream stream = file.getStream();
        if (null == stream) {
            LOG.warn((Object)"(Possible) Image file misses stream data");
            return file;
        }
        boolean bl = markSupported = file.repetitive() ? false : stream.markSupported();
        if (markSupported) {
            stream.mark(131072);
        }
        ImageTransformations transformations = this.scaler.transfom(stream);
        Boolean bl2 = rotate = request.isSet("rotate") ? request.getParameter("rotate", Boolean.class) : null;
        if (null == rotate && !DOWNLOAD.equalsIgnoreCase(delivery) || null != rotate && rotate.booleanValue()) {
            transformations.rotate();
        }
        if (request.isSet("cropWidth") || request.isSet("cropHeight")) {
            int cropX = request.isSet("cropX") ? request.getParameter("cropX", Integer.TYPE) : 0;
            int cropY = request.isSet("cropY") ? request.getParameter("cropY", Integer.TYPE) : 0;
            int cropWidth = request.getParameter("cropWidth", Integer.TYPE);
            int cropHeight = request.getParameter("cropHeight", Integer.TYPE);
            transformations.crop(cropX, cropY, cropWidth, cropHeight);
        }
        if (request.isSet("width") || request.isSet("height")) {
            int maxWidth = request.isSet("width") ? request.getParameter("width", Integer.TYPE) : 0;
            int maxHeight = request.isSet("height") ? request.getParameter("height", Integer.TYPE) : 0;
            ScaleType scaleType = ScaleType.getType(request.getParameter("scaleType"));
            transformations.scale(maxWidth, maxHeight, scaleType);
        }
        Boolean bl3 = compress = request.isSet("compress") ? request.getParameter("compress", Boolean.class) : null;
        if (null == compress && !DOWNLOAD.equalsIgnoreCase(delivery) || null != compress && compress.booleanValue()) {
            transformations.compress();
        }
        if (null == (transformed = transformations.getInputStream(file.getContentType()))) {
            LOG.warn((Object)"Got no resulting input stream from transformation, trying to recover original input");
            if (markSupported) {
                try {
                    stream.reset();
                    return file;
                }
                catch (Exception e) {
                    LOG.warn((Object)"Error resetting input stream", (Throwable)e);
                }
            }
            LOG.error((Object)("Unable to transform image from " + file));
            return file.repetitive() ? file : null;
        }
        return new FileHolder(transformed, -1L, file.getContentType(), file.getName());
    }

    private String checkedContentDisposition(String contentDisposition, IFileHolder file) {
        String ct = this.toLowerCase(file.getContentType());
        if (null == ct || ct.startsWith("text/htm")) {
            int pos = contentDisposition.indexOf(59);
            return pos > 0 ? "attachment" + contentDisposition.substring(pos) : "attachment";
        }
        return contentDisposition;
    }

    private boolean isImage(IFileHolder file) {
        String fileName;
        String contentType = file.getContentType();
        return null != contentType && contentType.startsWith("image/") || (fileName = file.getName()) != null && (contentType = MimeType2ExtMap.getContentType(fileName)).startsWith("image/");
    }

    private String toLowerCase(CharSequence chars) {
        if (null == chars) {
            return null;
        }
        int length = chars.length();
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = chars.charAt(i);
            builder.append(c >= 'A' && c <= 'Z' ? (char)(c ^ 0x20) : c);
        }
        return builder.toString();
    }

    private boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Character.isWhitespace(string.charAt(i));
        }
        return isWhitespace;
    }
}

