/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.converters.preview;

import com.openexchange.ajax.container.FileHolder;
import com.openexchange.ajax.container.IFileHolder;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.Converter;
import com.openexchange.ajax.requesthandler.ResultConverter;
import com.openexchange.ajax.requesthandler.converters.preview.AbstractPreviewResultConverter;
import com.openexchange.conversion.Data;
import com.openexchange.conversion.DataProperties;
import com.openexchange.conversion.SimpleData;
import com.openexchange.exception.OXException;
import com.openexchange.java.StringAllocator;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.preview.PreviewDocument;
import com.openexchange.preview.PreviewExceptionCodes;
import com.openexchange.preview.PreviewOutput;
import com.openexchange.preview.PreviewService;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class PreviewImageResultConverter
extends AbstractPreviewResultConverter {
    private static final Set<String> INVALIDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("application/octet-stream", "application/force-download", "application/binary", "application/x-download", "application/octet-stream", "application/vnd", "application/vnd.ms-word.document.12n", "application/odt", "application/x-pdf")));

    @Override
    public String getOutputFormat() {
        return "preview_image";
    }

    @Override
    public ResultConverter.Quality getQuality() {
        return ResultConverter.Quality.GOOD;
    }

    @Override
    public PreviewOutput getOutput() {
        return PreviewOutput.IMAGE;
    }

    @Override
    public void convert(AJAXRequestData requestData, AJAXRequestResult result, ServerSession session, Converter converter) throws OXException {
        try {
            Object resultObject = result.getResultObject();
            if (!(resultObject instanceof IFileHolder)) {
                throw AjaxExceptionCodes.UNEXPECTED_RESULT.create(IFileHolder.class.getSimpleName(), null == resultObject ? "null" : resultObject.getClass().getSimpleName());
            }
            IFileHolder fileHolder = (IFileHolder)resultObject;
            PreviewService previewService = ServerServiceRegistry.getInstance().getService(PreviewService.class);
            DataProperties dataProperties = new DataProperties(4);
            dataProperties.put("com.openexchange.conversion.content-type", this.getContentType(fileHolder));
            dataProperties.put("com.openexchange.conversion.disposition", fileHolder.getDisposition());
            dataProperties.put("com.openexchange.conversion.name", fileHolder.getName());
            dataProperties.put("com.openexchange.conversion.size", Long.toString(fileHolder.getLength()));
            PreviewDocument previewDocument = previewService.getPreviewFor((Data)new SimpleData((Object)fileHolder.getStream(), dataProperties), this.getOutput(), (Session)session, 1);
            requestData.setFormat("file");
            InputStream thumbnail = previewDocument.getThumbnail();
            if (null == thumbnail) {
                throw PreviewExceptionCodes.THUMBNAIL_NOT_AVAILABLE.create();
            }
            String fileName = (String)previewDocument.getMetaData().get("resourcename");
            FileHolder responseFileHolder = new FileHolder(thumbnail, -1L, "image/jpeg", fileName);
            result.setResultObject(responseFileHolder, "file");
        }
        catch (RuntimeException e) {
            throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    private String getContentType(IFileHolder fileHolder) {
        String contentType = this.getLowerCaseBaseType(fileHolder.getContentType());
        if (this.isEmpty(contentType) || INVALIDS.contains(contentType)) {
            contentType = MimeType2ExtMap.getContentType(fileHolder.getName());
        }
        return contentType == null ? "application/octet-stream" : contentType;
    }

    private String getLowerCaseBaseType(String contentType) {
        if (null == contentType) {
            return null;
        }
        int pos = contentType.indexOf(59);
        return this.toLowerCase(pos > 0 ? contentType.substring(0, pos) : contentType).trim();
    }

    private String toLowerCase(CharSequence chars) {
        int length = chars.length();
        StringAllocator builder = new StringAllocator(length);
        for (int i = 0; i < length; ++i) {
            char c = chars.charAt(i);
            builder.append(c >= 'A' && c <= 'Z' ? (char)(c ^ 0x20) : c);
        }
        return builder.toString();
    }

    private boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Character.isWhitespace(string.charAt(i));
        }
        return isWhitespace;
    }
}

