/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.request;

import com.openexchange.ajax.Attachment;
import com.openexchange.ajax.Infostore;
import com.openexchange.ajax.parser.InfostoreParser;
import com.openexchange.ajax.request.CommonRequest;
import com.openexchange.ajax.request.SimpleRequest;
import com.openexchange.ajax.writer.InfostoreWriter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.AttachmentBase;
import com.openexchange.groupware.attach.AttachmentField;
import com.openexchange.groupware.attach.AttachmentMetadata;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.CreatedByComparator;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.InfostoreFacade;
import com.openexchange.groupware.infostore.InfostoreSearchEngine;
import com.openexchange.groupware.infostore.database.impl.DocumentMetadataImpl;
import com.openexchange.groupware.infostore.utils.GetSwitch;
import com.openexchange.groupware.infostore.utils.Metadata;
import com.openexchange.groupware.infostore.utils.SetSwitch;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.results.Delta;
import com.openexchange.groupware.results.TimedResult;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.java.Streams;
import com.openexchange.log.LogFactory;
import com.openexchange.sessiond.impl.ThreadLocalSessionHolder;
import com.openexchange.tools.TimeZoneUtils;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIteratorException;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONWriter;

public class InfostoreRequest
extends CommonRequest {
    private static final InfostoreParser PARSER = new InfostoreParser();
    private final ServerSession session;
    private final Context ctx;
    private final User user;
    private final UserConfiguration userConfiguration;
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(InfostoreRequest.class));

    public InfostoreRequest(ServerSession session, JSONWriter w) {
        super(w);
        this.ctx = session.getContext();
        this.session = session;
        this.userConfiguration = session.getUserConfiguration();
        this.user = session.getUser();
    }

    public static boolean hasPermission(UserConfiguration userConfig) {
        return userConfig.hasInfostore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean action(String action, SimpleRequest req) throws OXException {
        if (!InfostoreRequest.hasPermission(this.userConfiguration)) {
            throw OXException.noPermissionForModule((String)"infostore");
        }
        try {
            ThreadLocalSessionHolder.getInstance().setSession(this.session);
            if (action.equals("all")) {
                if (!this.checkRequired(req, "folder", "columns")) {
                    boolean bl = true;
                    return bl;
                }
                this.doSortedSearch(req);
                boolean bl = true;
                return bl;
            }
            if (action.equals("updates")) {
                if (!this.checkRequired(req, "folder", "columns", "timestamp")) {
                    boolean bl = true;
                    return bl;
                }
                this.doSortedSearch(req);
                boolean bl = true;
                return bl;
            }
            if (action.equals("get")) {
                if (!this.checkRequired(req, "id", new String[0])) {
                    boolean bl = true;
                    return bl;
                }
                int id = Integer.parseInt(req.getParameter("id"));
                int version2 = -1;
                if (req.getParameter("version") != null) {
                    version2 = Integer.parseInt(req.getParameter("version"));
                }
                String timeZoneId = req.getParameter("timezone");
                this.get(id, version2, timeZoneId);
                boolean bl = true;
                return bl;
            }
            if (action.equals("versions")) {
                if (!this.checkRequired(req, "id", "columns")) {
                    boolean id = true;
                    return id;
                }
                this.doSortedSearch(req);
                boolean id = true;
                return id;
            }
            if (action.equals("revert")) {
                if (!this.checkRequired(req, "id", "timestamp")) {
                    boolean id = true;
                    return id;
                }
                int id = Integer.parseInt(req.getParameter("id"));
                long ts = Long.parseLong(req.getParameter("timestamp"));
                this.revert(id, ts);
                boolean bl = true;
                return bl;
            }
            if (action.equals("list")) {
                if (!this.checkRequired(req, "columns", new String[0])) {
                    boolean id = true;
                    return id;
                }
                JSONArray array = (JSONArray)req.getBody();
                int[] ids = this.parseIDList(array, null);
                Metadata[] cols = null;
                try {
                    cols = PARSER.getColumns(req.getParameterValues("columns"));
                }
                catch (InfostoreParser.UnknownMetadataException x) {
                    this.unknownColumn(x.getColumnId());
                    boolean bl = true;
                    ThreadLocalSessionHolder.getInstance().clear();
                    return bl;
                }
                String timeZoneId = req.getParameter("timezone");
                this.list(ids, cols, timeZoneId);
                boolean bl = true;
                return bl;
            }
            if (action.equals("delete")) {
                if (!this.checkRequired(req, "timestamp", new String[0])) {
                    boolean array = true;
                    return array;
                }
                Object toDelete = req.getBody();
                TIntIntHashMap folderMapping = new TIntIntHashMap();
                int[] ids = this.parseIDList(toDelete, (TIntIntMap)folderMapping);
                long timestamp = Long.parseLong(req.getParameter("timestamp"));
                this.delete(ids, (TIntIntMap)folderMapping, timestamp);
                boolean bl = true;
                return bl;
            }
            if (action.equals("detach")) {
                int i;
                if (!this.checkRequired(req, "timestamp", "id")) {
                    boolean toDelete = true;
                    return toDelete;
                }
                JSONArray array = (JSONArray)req.getBody();
                long timestamp = Long.parseLong(req.getParameter("timestamp"));
                int id = Integer.parseInt(req.getParameter("id"));
                int[] versions = new int[array.length()];
                for (i = 0; i < array.length(); i += 1) {
                    versions[i] = array.getInt(i);
                }
                this.detach(id, versions, timestamp);
                i = 1;
                return i != 0;
            }
            if (action.equals("update") || action.equals("copy")) {
                if (!this.checkRequired(req, "id", "timestamp")) {
                    boolean array = true;
                    return array;
                }
                int id = Integer.parseInt(req.getParameter("id"));
                long timestamp = Long.parseLong(req.getParameter("timestamp"));
                String updateBody = req.getBody().toString();
                DocumentMetadata updated = PARSER.getDocumentMetadata(updateBody);
                updated.setId(id);
                Metadata[] presentFields = null;
                try {
                    presentFields = PARSER.findPresentFields(updateBody);
                }
                catch (InfostoreParser.UnknownMetadataException x) {
                    this.unknownColumn(x.getColumnId());
                    boolean bl = true;
                    ThreadLocalSessionHolder.getInstance().clear();
                    return bl;
                }
                if (action.equals("update")) {
                    this.update(id, updated, timestamp, presentFields);
                } else {
                    this.copy(id, updated, timestamp, presentFields);
                }
                boolean x = true;
                return x;
            }
            if (action.equals("new")) {
                DocumentMetadata newDocument = PARSER.getDocumentMetadata(req.getBody().toString());
                this.newDocument(newDocument);
                boolean timestamp = true;
                return timestamp;
            }
            if (action.equals("lock")) {
                if (!this.checkRequired(req, action, "id")) {
                    boolean newDocument = true;
                    return newDocument;
                }
                long diff = -1L;
                if (null != req.getParameter("diff")) {
                    diff = Long.parseLong(req.getParameter("diff"));
                }
                int id = Integer.parseInt(req.getParameter("id"));
                this.lock(id, diff);
                boolean updateBody = true;
                return updateBody;
            }
            if (action.equals("unlock")) {
                if (!this.checkRequired(req, action, "id")) {
                    boolean diff = true;
                    return diff;
                }
                this.unlock(Integer.parseInt(req.getParameter("id")));
                boolean diff = true;
                return diff;
            }
            if (action.equals("search")) {
                if (!this.checkRequired(req, action, "columns")) {
                    boolean diff = true;
                    return diff;
                }
                this.doSortedSearch(req);
                boolean diff = true;
                return diff;
            }
            if (action.equals("saveAs")) {
                if (!this.checkRequired(req, action, "folder", "attached", "module", "attachment")) {
                    boolean diff = true;
                    return diff;
                }
                int folderId = Integer.parseInt(req.getParameter("folder"));
                int attachedId = Integer.parseInt(req.getParameter("attached"));
                int moduleId = Integer.parseInt(req.getParameter("module"));
                int attachment = Integer.parseInt(req.getParameter("attachment"));
                String body = req.getBody().toString();
                DocumentMetadata newDocument = PARSER.getDocumentMetadata(body);
                Metadata[] fields = PARSER.findPresentFields(body);
                this.saveAs(newDocument, fields, folderId, attachedId, moduleId, attachment);
                boolean bl = true;
                return bl;
            }
            boolean folderId = false;
            return folderId;
        }
        catch (JSONException x) {
            this.handle(x, this.session);
            boolean bl = true;
            return bl;
        }
        catch (InfostoreParser.UnknownMetadataException x) {
            this.handle(x, this.session);
            boolean bl = true;
            return bl;
        }
        catch (OXException x) {
            this.handle(x, this.session);
            boolean bl = true;
            return bl;
        }
        catch (NumberFormatException x) {
            this.handle(x, this.session);
            boolean bl = true;
            return bl;
        }
        catch (Throwable t) {
            this.handle(t, this.session);
            boolean bl = true;
            return bl;
        }
        finally {
            ThreadLocalSessionHolder.getInstance().clear();
        }
    }

    protected int[] parseIDList(Object toDelete, TIntIntMap folderMapping) throws JSONException {
        if (JSONArray.class.isAssignableFrom(toDelete.getClass())) {
            JSONArray array = (JSONArray)toDelete;
            int[] ids = new int[array.length()];
            for (int i = 0; i < array.length(); ++i) {
                JSONObject tuple = array.getJSONObject(i);
                try {
                    ids[i] = tuple.getInt("id");
                }
                catch (JSONException x) {
                    ids[i] = Integer.parseInt(tuple.getString("id"));
                }
                if (folderMapping == null) continue;
                int folder = -1;
                try {
                    folder = tuple.getInt("folder");
                }
                catch (JSONException x) {
                    folder = Integer.parseInt("folder");
                }
                folderMapping.put(ids[i], folder);
            }
            return ids;
        }
        int[] ids = new int[]{((JSONObject)toDelete).getInt("id")};
        return ids;
    }

    protected void doSortedSearch(SimpleRequest req) throws JSONException, OXException {
        String action;
        Metadata[] cols = null;
        try {
            cols = PARSER.getColumns(req.getParameterValues("columns"));
        }
        catch (InfostoreParser.UnknownMetadataException x) {
            this.unknownColumn(x.getColumnId());
            return;
        }
        String sort = req.getParameter("sort");
        String order = req.getParameter("order");
        if (order != null && !this.checkRequired(req, "sort", new String[0])) {
            return;
        }
        Metadata sortedBy = null;
        int dir = -23;
        if (sort != null) {
            dir = 1;
            if (order != null && order.equalsIgnoreCase("DESC")) {
                dir = -1;
            }
            if ((sortedBy = Metadata.get(Integer.parseInt(sort))) == null) {
                this.invalidParameter("sort", sort);
                return;
            }
        }
        if ((action = req.getParameter("action")).equals("all")) {
            if (!this.checkRequired(req, action, "folder")) {
                return;
            }
            int folderId = Integer.parseInt(req.getParameter("folder"));
            String timeZoneId = req.getParameter("timezone");
            String stringLeftHandLimit = req.getParameter("left_hand_limit");
            String stringRightHandLimit = req.getParameter("right_hand_limit");
            int leftHandLimit = stringLeftHandLimit == null ? 0 : Integer.parseInt("left_hand_limit");
            int rightHandLimit = stringRightHandLimit == null ? 0 : Integer.parseInt("right_hand_limit");
            this.all(folderId, cols, sortedBy, dir, timeZoneId, leftHandLimit, rightHandLimit);
        } else if (action.equals("versions")) {
            if (!this.checkRequired(req, action, "id")) {
                return;
            }
            int id = Integer.parseInt(req.getParameter("id"));
            String timeZoneId = req.getParameter("timezone");
            this.versions(id, cols, sortedBy, dir, timeZoneId);
        } else if (action.equals("updates")) {
            if (!this.checkRequired(req, action, "folder", "timestamp")) {
                return;
            }
            int folderId = Integer.parseInt(req.getParameter("folder"));
            long timestamp = Long.parseLong(req.getParameter("timestamp"));
            String delete = req.getParameter("ignore");
            String timeZoneId = req.getParameter("timezone");
            this.updates(folderId, cols, sortedBy, dir, timestamp, delete != null && delete.equals("deleted"), timeZoneId);
        } else if (action.equals("search")) {
            String limitS;
            JSONObject queryObject = (JSONObject)req.getBody();
            String query = queryObject.getString("pattern");
            int folderId = -10;
            String folderS = req.getParameter("folder");
            if (null != folderS) {
                folderId = Integer.parseInt(folderS);
            }
            int start = -11;
            String startS = req.getParameter("start");
            if (null != startS) {
                start = Integer.parseInt(startS);
            }
            int end = -11;
            String endS = req.getParameter("end");
            if (null != endS) {
                end = Integer.parseInt(endS);
            }
            if (start == -11 && end == -11 && (limitS = req.getParameter("limit")) != null) {
                int limit = Integer.parseInt(limitS);
                start = 0;
                end = limit - 1;
            }
            String timeZoneId = req.getParameter("timezone");
            this.search(query, cols, folderId, sortedBy, dir, start, end, timeZoneId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void list(int[] ids, Metadata[] cols, String timeZoneId) throws OXException {
        InfostoreFacade infostore = this.getInfostore();
        TimedResult<DocumentMetadata> result = null;
        SearchIterator iter = null;
        try {
            result = infostore.getDocuments(ids, cols, this.ctx, this.user, this.userConfiguration);
            iter = result.results();
            InfostoreWriter iWriter = new InfostoreWriter(this.w);
            iWriter.timedResult(result.sequenceNumber());
            iWriter.writeMetadata((SearchIterator<DocumentMetadata>)iter, cols, TimeZoneUtils.getTimeZone(null == timeZoneId ? this.user.getTimeZone() : timeZoneId));
            iWriter.endTimedResult();
        }
        catch (Throwable t) {
            this.handle(t, this.session);
        }
        finally {
            if (iter != null) {
                try {
                    iter.close();
                }
                catch (OXException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    protected void get(int id, int version2, String timeZoneId) {
        InfostoreFacade infostore = this.getInfostore();
        DocumentMetadata dm = null;
        try {
            dm = infostore.getDocumentMetadata(id, version2, this.ctx, this.user, this.userConfiguration);
            if (dm == null) {
                this.sendErrorAsJS("Cannot find document: %s ", Integer.toString(id));
            }
        }
        catch (Throwable t) {
            this.handle(t, this.session);
            return;
        }
        try {
            InfostoreWriter iWriter = new InfostoreWriter(this.w);
            iWriter.timedResult(dm.getSequenceNumber());
            iWriter.write(dm, TimeZoneUtils.getTimeZone(null == timeZoneId ? this.user.getTimeZone() : timeZoneId));
            iWriter.endTimedResult();
        }
        catch (JSONException e) {
            LOG.error((Object)"", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void revert(int id, long ts) {
        InfostoreFacade infostore = this.getInfostore();
        SearchIterator iter = null;
        long timestamp = -1L;
        try {
            TIntArrayList versions;
            infostore.startTransaction();
            infostore.getDocumentMetadata(id, -1, this.ctx, this.user, this.userConfiguration).getSequenceNumber();
            TimedResult<DocumentMetadata> result = infostore.getVersions(id, new Metadata[]{Metadata.VERSION_LITERAL}, this.ctx, this.user, this.userConfiguration);
            if (timestamp > ts) {
                throw AjaxExceptionCodes.CONFLICT.create();
            }
            iter = result.results();
            try {
                versions = new TIntArrayList();
                while (iter.hasNext()) {
                    int version2 = ((DocumentMetadata)iter.next()).getVersion();
                    if (version2 == 0) continue;
                    versions.add(version2);
                }
            }
            finally {
                iter.close();
            }
            infostore.removeVersion(id, versions.toArray(), this.session);
            timestamp = infostore.getDocumentMetadata(id, -1, this.ctx, this.user, this.userConfiguration).getSequenceNumber();
            infostore.commit();
            this.w.object();
            this.w.key("data").value((Object)new JSONObject()).key("timestamp").value(timestamp);
            this.w.endObject();
        }
        catch (Throwable t) {
            try {
                infostore.rollback();
            }
            catch (OXException e) {
                LOG.debug((Object)"", (Throwable)e);
            }
            this.handle(t, this.session);
            return;
        }
        finally {
            if (iter != null) {
                try {
                    iter.close();
                }
                catch (OXException e) {
                    LOG.error((Object)"", (Throwable)e);
                }
            }
            try {
                infostore.finish();
            }
            catch (OXException e1) {
                LOG.error((Object)"", (Throwable)e1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void all(int folderId, Metadata[] cols, Metadata sortedBy, int dir, String timeZoneId, int leftHandLimit, int rightHandLimit) throws OXException {
        InfostoreFacade infostore = this.getInfostore(folderId);
        TimedResult<DocumentMetadata> result = null;
        SearchIterator<DocumentMetadata> iter = null;
        try {
            result = sortedBy == null ? infostore.getDocuments(folderId, cols, this.ctx, this.user, this.userConfiguration) : infostore.getDocuments(folderId, cols, sortedBy, dir, this.ctx, this.user, this.userConfiguration);
            iter = result.results();
            if (Metadata.CREATED_BY_LITERAL.equals(sortedBy)) {
                iter = CreatedByComparator.resort(iter, new CreatedByComparator(this.user.getLocale(), this.ctx).setDescending(dir < 0));
            }
            InfostoreWriter iWriter = new InfostoreWriter(this.w);
            iWriter.timedResult(result.sequenceNumber());
            iWriter.writeMetadata(iter, cols, TimeZoneUtils.getTimeZone(null == timeZoneId ? this.user.getTimeZone() : timeZoneId));
            iWriter.endTimedResult();
        }
        catch (Throwable t) {
            this.handle(t, this.session);
            return;
        }
        finally {
            if (iter != null) {
                iter.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void versions(int id, Metadata[] cols, Metadata sortedBy, int dir, String timeZoneId) throws OXException {
        InfostoreFacade infostore = this.getInfostore();
        TimedResult<DocumentMetadata> result = null;
        SearchIterator<DocumentMetadata> iter = null;
        Metadata[] loadCols = this.addIfNeeded(cols, Metadata.VERSION_LITERAL);
        try {
            result = sortedBy == null ? infostore.getVersions(id, loadCols, this.ctx, this.user, this.userConfiguration) : infostore.getVersions(id, loadCols, sortedBy, dir, this.ctx, this.user, this.userConfiguration);
            iter = result.results();
            if (Metadata.CREATED_BY_LITERAL.equals(sortedBy)) {
                iter = CreatedByComparator.resort(iter, new CreatedByComparator(this.user.getLocale(), this.ctx).setDescending(dir < 0));
            }
            InfostoreWriter iWriter = new InfostoreWriter(this.w);
            iWriter.timedResult(result.sequenceNumber());
            iWriter.writeMetadata(this.skipVersion0(iter), cols, TimeZoneUtils.getTimeZone(null == timeZoneId ? this.user.getTimeZone() : timeZoneId));
            iWriter.endTimedResult();
        }
        catch (Throwable t) {
            this.handle(t, this.session);
            return;
        }
        finally {
            if (iter != null) {
                iter.close();
            }
        }
    }

    private Metadata[] addIfNeeded(Metadata[] cols, Metadata column) {
        ArrayList<Metadata> newCols = new ArrayList<Metadata>(cols.length + 1);
        for (Metadata metadata : cols) {
            if (metadata == column) {
                return cols;
            }
            newCols.add(metadata);
        }
        newCols.add(column);
        return newCols.toArray(new Metadata[cols.length + 1]);
    }

    private SearchIterator<DocumentMetadata> skipVersion0(final SearchIterator<DocumentMetadata> iter) {
        return new SearchIterator<DocumentMetadata>(){
            private DocumentMetadata next;
            private SearchIteratorException se;
            private OXException oxe;

            public void addWarning(OXException warning) {
                iter.addWarning(warning);
            }

            public void close() throws OXException {
                iter.close();
            }

            public OXException[] getWarnings() {
                return iter.getWarnings();
            }

            public boolean hasNext() throws OXException {
                try {
                    this.scrollToNext();
                }
                catch (OXException e) {
                    this.oxe = e;
                }
                return this.next != null;
            }

            public boolean hasWarnings() {
                return iter.hasWarnings();
            }

            public DocumentMetadata next() throws OXException {
                if (this.se != null) {
                    throw this.se;
                }
                if (this.oxe != null) {
                    throw this.oxe;
                }
                if (this.next == null) {
                    this.scrollToNext();
                }
                DocumentMetadata nextResult = this.next;
                this.next = null;
                return nextResult;
            }

            private void scrollToNext() throws OXException {
                while (iter.hasNext()) {
                    this.next = (DocumentMetadata)iter.next();
                    if (this.next.getVersion() != 0) {
                        return;
                    }
                    this.next = null;
                }
            }

            public int size() {
                return -1;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updates(int folderId, Metadata[] cols, Metadata sortedBy, int dir, long timestamp, boolean ignoreDelete, String timeZoneId) throws OXException {
        InfostoreFacade infostore = this.getInfostore(folderId);
        Delta<DocumentMetadata> delta = null;
        SearchIterator<DocumentMetadata> iter = null;
        SearchIterator<DocumentMetadata> iter2 = null;
        try {
            delta = sortedBy == null ? infostore.getDelta(folderId, timestamp, cols, ignoreDelete, this.ctx, this.user, this.userConfiguration) : infostore.getDelta(folderId, timestamp, cols, sortedBy, dir, ignoreDelete, this.ctx, this.user, this.userConfiguration);
            iter = delta.results();
            iter2 = delta.getDeleted();
            if (Metadata.CREATED_BY_LITERAL.equals(sortedBy)) {
                CreatedByComparator comparator = new CreatedByComparator(this.user.getLocale(), this.ctx).setDescending(dir < 0);
                iter = CreatedByComparator.resort(iter, comparator);
                iter2 = CreatedByComparator.resort(iter2, comparator);
            }
            InfostoreWriter iWriter = new InfostoreWriter(this.w);
            iWriter.timedResult(delta.sequenceNumber());
            iWriter.writeDelta(iter, iter2, cols, ignoreDelete, TimeZoneUtils.getTimeZone(null == timeZoneId ? this.user.getTimeZone() : timeZoneId));
            iWriter.endTimedResult();
        }
        catch (Throwable t) {
            this.handle(t, this.session);
            return;
        }
        finally {
            if (iter != null) {
                iter.close();
            }
            if (iter2 != null) {
                iter2.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void delete(int[] ids, TIntIntMap folderMapping, long timestamp) {
        int[] notDeleted;
        block22: {
            InfostoreFacade infostore = this.getInfostore();
            InfostoreSearchEngine searchEngine = this.getSearchEngine();
            notDeleted = new int[]{};
            if (ids.length != 0) {
                infostore.startTransaction();
                searchEngine.startTransaction();
                notDeleted = infostore.removeDocument(ids, timestamp, this.session);
                TIntHashSet notDeletedSet = new TIntHashSet();
                for (int nd : notDeleted) {
                    notDeletedSet.add(nd);
                }
                for (int id : ids) {
                    if (notDeletedSet.contains(id)) continue;
                    searchEngine.unIndex0r(id, this.ctx, this.user, this.userConfiguration);
                }
                infostore.commit();
                searchEngine.commit();
                try {
                    infostore.finish();
                    searchEngine.finish();
                }
                catch (OXException e) {
                    LOG.error((Object)"", (Throwable)e);
                }
                break block22;
                catch (Throwable t) {
                    infostore.rollback();
                    searchEngine.rollback();
                    this.handle(t, this.session);
                    try {
                        infostore.finish();
                        searchEngine.finish();
                    }
                    catch (OXException e) {
                        LOG.error((Object)"", (Throwable)e);
                    }
                    return;
                    {
                        catch (OXException e) {
                            try {
                                LOG.error((Object)"", (Throwable)e);
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                try {
                                    infostore.finish();
                                    searchEngine.finish();
                                }
                                catch (OXException e2) {
                                    LOG.error((Object)"", (Throwable)e2);
                                }
                            }
                        }
                    }
                }
            }
        }
        try {
            this.w.object();
            this.w.key("data");
            this.w.array();
            for (int i = 0; i < notDeleted.length; ++i) {
                this.w.object();
                this.w.key("id");
                int nd = notDeleted[i];
                this.w.value((long)nd);
                this.w.key("folder");
                this.w.value((long)folderMapping.get(nd));
                this.w.endObject();
            }
            this.w.endArray();
            this.w.endObject();
        }
        catch (JSONException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void detach(int objectId, int[] ids, long timestamp) {
        InfostoreFacade infostore = this.getInfostore();
        InfostoreSearchEngine searchEngine = this.getSearchEngine();
        int[] notDetached = new int[]{};
        long newTimestamp = 0L;
        if (ids.length != 0) {
            try {
                infostore.startTransaction();
                searchEngine.startTransaction();
                notDetached = infostore.removeVersion(objectId, ids, this.session);
                DocumentMetadata currentVersion = infostore.getDocumentMetadata(objectId, -1, this.ctx, this.user, this.userConfiguration);
                searchEngine.index(currentVersion, this.ctx, this.user, this.userConfiguration);
                newTimestamp = currentVersion.getLastModified().getTime();
                infostore.commit();
                searchEngine.commit();
            }
            catch (Throwable t) {
                try {
                    infostore.rollback();
                    searchEngine.rollback();
                }
                catch (OXException e) {
                    LOG.error((Object)"", (Throwable)e);
                }
                this.handle(t, this.session);
                return;
            }
            finally {
                try {
                    infostore.finish();
                    searchEngine.finish();
                }
                catch (OXException e) {
                    LOG.error((Object)"", (Throwable)e);
                }
            }
        }
        try {
            this.w.object();
            this.w.key("data");
            this.w.array();
            for (int i = 0; i < notDetached.length; ++i) {
                int nd = notDetached[i];
                this.w.value((long)nd);
            }
            this.w.endArray();
            this.w.key("timestamp");
            this.w.value(newTimestamp);
            this.w.endObject();
        }
        catch (JSONException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void newDocument(DocumentMetadata newDocument) throws JSONException {
        InfostoreFacade infostore = this.getInfostore(newDocument.getFolderId());
        InfostoreSearchEngine searchEngine = this.getSearchEngine();
        try {
            infostore.startTransaction();
            searchEngine.startTransaction();
            infostore.saveDocumentMetadata(newDocument, System.currentTimeMillis(), this.session);
            infostore.commit();
            searchEngine.index(newDocument, this.ctx, this.user, this.userConfiguration);
            searchEngine.commit();
        }
        catch (Throwable t) {
            try {
                infostore.rollback();
                searchEngine.rollback();
            }
            catch (OXException e) {
                LOG.error((Object)"", (Throwable)e);
            }
            this.handle(t, this.session);
            return;
        }
        finally {
            try {
                infostore.finish();
                searchEngine.finish();
            }
            catch (OXException e) {
                LOG.error((Object)"", (Throwable)e);
            }
        }
        this.w.object();
        this.w.key("data").value((long)newDocument.getId());
        this.w.endObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void saveAs(DocumentMetadata newDocument, Metadata[] fields, int folderId, int attachedId, int moduleId, int attachment) throws JSONException {
        HashSet<Metadata> alreadySet = new HashSet<Metadata>(Arrays.asList(fields));
        if (!alreadySet.contains(Metadata.FOLDER_ID_LITERAL)) {
            this.missingParameter("folder_id in object", "saveAs");
        }
        AttachmentBase attachmentBase = Attachment.ATTACHMENT_BASE;
        InfostoreFacade infostore = this.getInfostore(newDocument.getFolderId());
        InfostoreSearchEngine searchEngine = this.getSearchEngine();
        InputStream in = null;
        try {
            attachmentBase.startTransaction();
            infostore.startTransaction();
            searchEngine.startTransaction();
            AttachmentMetadata att = attachmentBase.getAttachment(this.session, folderId, attachedId, moduleId, attachment, this.ctx, this.user, this.userConfiguration);
            com.openexchange.groupware.attach.util.GetSwitch get = new com.openexchange.groupware.attach.util.GetSwitch(att);
            SetSwitch set = new SetSwitch(newDocument);
            for (Metadata attachmentCompatible : Metadata.VALUES) {
                AttachmentField attField;
                if (alreadySet.contains(attachmentCompatible) || null == (attField = Metadata.getAttachmentField(attachmentCompatible))) continue;
                Object value = attField.doSwitch(get);
                set.setValue(value);
                attachmentCompatible.doSwitch(set);
            }
            newDocument.setId(-1);
            in = attachmentBase.getAttachedFile(this.session, folderId, attachedId, moduleId, attachment, this.ctx, this.user, this.userConfiguration);
            infostore.saveDocument(newDocument, in, System.currentTimeMillis(), this.session);
            searchEngine.index(newDocument, this.ctx, this.user, this.userConfiguration);
            infostore.commit();
            searchEngine.commit();
            attachmentBase.commit();
        }
        catch (Throwable t) {
            try {
                try {
                    infostore.rollback();
                    searchEngine.rollback();
                    attachmentBase.rollback();
                }
                catch (OXException e) {
                    LOG.error((Object)"", (Throwable)e);
                }
                this.handle(t, this.session);
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    infostore.finish();
                    searchEngine.finish();
                    attachmentBase.finish();
                }
                catch (OXException e) {
                    LOG.error((Object)"", (Throwable)e);
                }
                Streams.close(in);
            }
        }
        try {
            infostore.finish();
            searchEngine.finish();
            attachmentBase.finish();
        }
        catch (OXException e) {
            LOG.error((Object)"", (Throwable)e);
        }
        Streams.close((Closeable)in);
        this.w.object();
        this.w.key("data").value((long)newDocument.getId());
        this.w.endObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update(int id, DocumentMetadata updated, long timestamp, Metadata[] presentFields) {
        InfostoreFacade infostore = this.getInfostore(updated.getFolderId());
        InfostoreSearchEngine searchEngine = this.getSearchEngine();
        try {
            infostore.startTransaction();
            searchEngine.startTransaction();
            boolean version2 = false;
            for (Metadata m : presentFields) {
                if (!m.equals(Metadata.VERSION_LITERAL)) continue;
                version2 = true;
                break;
            }
            if (!version2) {
                updated.setVersion(-1);
            }
            infostore.saveDocumentMetadata(updated, timestamp, presentFields, this.session);
            infostore.commit();
            searchEngine.commit();
        }
        catch (Throwable t) {
            try {
                infostore.rollback();
                searchEngine.rollback();
            }
            catch (OXException e) {
                LOG.error((Object)"", (Throwable)e);
            }
            this.handle(t, this.session);
            return;
        }
        finally {
            try {
                infostore.finish();
                searchEngine.finish();
            }
            catch (OXException e) {
                LOG.error((Object)"", (Throwable)e);
            }
        }
        try {
            this.w.object();
            this.w.key("timestamp");
            this.w.value(updated.getLastModified().getTime());
            this.w.endObject();
        }
        catch (JSONException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copy(int id, DocumentMetadata updated, long timestamp, Metadata[] presentFields) {
        InfostoreFacade infostore = this.getInfostore(updated.getFolderId());
        InfostoreSearchEngine searchEngine = this.getSearchEngine();
        DocumentMetadataImpl metadata = null;
        try {
            infostore.startTransaction();
            searchEngine.startTransaction();
            metadata = new DocumentMetadataImpl(infostore.getDocumentMetadata(id, -1, this.ctx, this.user, this.userConfiguration));
            SetSwitch set = new SetSwitch(metadata);
            GetSwitch get = new GetSwitch(updated);
            for (Metadata field : presentFields) {
                Object value = field.doSwitch(get);
                set.setValue(value);
                field.doSwitch(set);
            }
            metadata.setVersion(0);
            metadata.setId(-1);
            if (metadata.getFileName() != null && !"".equals(metadata.getFileName())) {
                infostore.saveDocument(metadata, infostore.getDocument(id, -1, this.ctx, this.user, this.userConfiguration), metadata.getSequenceNumber(), this.session);
            } else {
                infostore.saveDocumentMetadata(metadata, timestamp, this.session);
            }
            searchEngine.index(metadata, this.ctx, this.user, this.userConfiguration);
            infostore.commit();
            searchEngine.commit();
        }
        catch (Throwable t) {
            try {
                infostore.rollback();
                searchEngine.rollback();
            }
            catch (OXException e) {
                LOG.error((Object)"", (Throwable)e);
            }
            this.handle(t, this.session);
            return;
        }
        finally {
            try {
                infostore.finish();
                searchEngine.finish();
            }
            catch (OXException e) {
                LOG.debug((Object)"", (Throwable)e);
            }
        }
        try {
            this.w.object();
            this.w.key("data").value((long)metadata.getId());
            this.w.endObject();
        }
        catch (JSONException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lock(int id, long diff) {
        InfostoreFacade infostore = this.getInfostore();
        try {
            infostore.startTransaction();
            infostore.lock(id, diff, this.session);
            infostore.commit();
            DocumentMetadata currentVersion = infostore.getDocumentMetadata(id, -1, this.ctx, this.user, this.userConfiguration);
            try {
                this.w.object();
                this.w.key("timestamp");
                this.w.value(currentVersion.getLastModified().getTime());
                this.w.endObject();
            }
            catch (JSONException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        catch (Throwable t) {
            try {
                infostore.rollback();
            }
            catch (OXException e) {
                LOG.error((Object)"", (Throwable)e);
            }
            this.handle(t, this.session);
        }
        finally {
            try {
                infostore.finish();
            }
            catch (OXException e) {
                LOG.error((Object)"", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlock(int id) {
        InfostoreFacade infostore = this.getInfostore();
        try {
            infostore.startTransaction();
            new DocumentMetadataImpl();
            infostore.unlock(id, this.session);
            infostore.commit();
            DocumentMetadata currentVersion = infostore.getDocumentMetadata(id, -1, this.ctx, this.user, this.userConfiguration);
            try {
                this.w.object().key("timestamp").value(currentVersion.getLastModified().getTime()).endObject();
            }
            catch (JSONException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        catch (Throwable t) {
            try {
                infostore.rollback();
            }
            catch (OXException e) {
                LOG.error((Object)"", (Throwable)e);
            }
            this.handle(t, this.session);
        }
        finally {
            try {
                infostore.finish();
            }
            catch (OXException e) {
                LOG.debug((Object)"", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void search(String query, Metadata[] cols, int folderId, Metadata sortedBy, int dir, int start, int end, String timeZoneId) {
        InfostoreSearchEngine searchEngine = this.getSearchEngine();
        try {
            searchEngine.startTransaction();
            SearchIterator<DocumentMetadata> results = searchEngine.search(query, cols, folderId, sortedBy, dir, start, end, this.ctx, this.user, this.userConfiguration);
            if (Metadata.CREATED_BY_LITERAL.equals(sortedBy)) {
                results = CreatedByComparator.resort(results, new CreatedByComparator(this.user.getLocale(), this.ctx).setDescending(dir < 0));
            }
            InfostoreWriter iWriter = new InfostoreWriter(this.w);
            iWriter.timedResult(System.currentTimeMillis());
            iWriter.writeMetadata(results, cols, TimeZoneUtils.getTimeZone(null == timeZoneId ? this.user.getTimeZone() : timeZoneId));
            iWriter.endTimedResult();
            searchEngine.commit();
        }
        catch (Throwable t) {
            try {
                searchEngine.rollback();
            }
            catch (OXException x) {
                LOG.debug((Object)"", (Throwable)x);
            }
            this.handle(t, this.session);
        }
        finally {
            try {
                searchEngine.finish();
            }
            catch (OXException x) {
                LOG.error((Object)"", (Throwable)x);
            }
        }
    }

    protected InfostoreFacade getInfostore() {
        return Infostore.FACADE;
    }

    protected InfostoreFacade getInfostore(long folderId) {
        return Infostore.getInfostore(folderId);
    }

    protected InfostoreSearchEngine getSearchEngine() {
        return Infostore.SEARCH_ENGINE;
    }
}

