/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.redirect;

import com.openexchange.ajax.AJAXServlet;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RedirectServlet
extends HttpServlet {
    private static final long serialVersionUID = 6111473866164506367L;
    private static final Pattern PROTOCOL_PATTERN = Pattern.compile("^(\\w*:)?//");

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        req.getSession(true);
        String location = req.getParameter("location");
        if (location == null) {
            resp.sendError(400);
            return;
        }
        if (!this.isRelative(location)) {
            resp.sendError(400);
            return;
        }
        if (this.isServerRelative(location)) {
            resp.sendRedirect(AJAXServlet.encodeUrl(location, true));
            return;
        }
        String referer = this.purgeHost(req.getHeader("referer"));
        if (referer == null) {
            resp.sendError(400);
            return;
        }
        location = this.assumeRelative(referer, location);
        resp.sendRedirect(AJAXServlet.encodeUrl(location, true));
    }

    private boolean isRelative(String location) {
        Matcher matcher = PROTOCOL_PATTERN.matcher(location);
        return !matcher.find();
    }

    private String purgeHost(String location) {
        if (location == null) {
            return null;
        }
        return location.replaceAll("^(\\w*:)?//\\w*/", "");
    }

    private boolean isServerRelative(String location) {
        return location.length() > 0 && location.charAt(0) == '/';
    }

    private String assumeRelative(String referer, String location) {
        if (referer.endsWith("/")) {
            return "/" + referer + location;
        }
        int index = referer.lastIndexOf(47);
        return "/" + referer.substring(0, index) + "/" + location;
    }
}

