/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.parser;

import com.openexchange.exception.OXException;
import com.openexchange.search.CompositeSearchTerm;
import com.openexchange.search.Operand;
import com.openexchange.search.SearchExceptionMessages;
import com.openexchange.search.SearchTerm;
import com.openexchange.search.SingleSearchTerm;
import com.openexchange.search.internal.operands.ColumnOperand;
import com.openexchange.search.internal.operands.ConstantOperand;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SearchTermParser {
    public static final SearchTermParser INSTANCE = new SearchTermParser();

    public static SearchTerm<?> parse(JSONArray jsonArray) throws OXException {
        return INSTANCE.parseSearchTerm(jsonArray);
    }

    public static void parseSingleOperands(SingleSearchTerm singleSearchTerm, JSONArray array, int maxTerms) throws OXException {
        INSTANCE.parseSingleOperands(array, singleSearchTerm, maxTerms);
    }

    protected SearchTermParser() {
    }

    public void parseSingleOperands(JSONArray array, SingleSearchTerm singleSearchTerm, int maxTerms) throws OXException {
        int len = array.length();
        if (len < 2) {
            throw SearchExceptionMessages.PARSING_FAILED_INVALID_SEARCH_TERM.create(new Object[0]);
        }
        if (len > maxTerms + 1) {
            throw SearchExceptionMessages.PARSING_FAILED_INVALID_SEARCH_TERM.create(new Object[0]);
        }
        for (int i = 1; i < len; ++i) {
            JSONObject operand = array.optJSONObject(i);
            if (null == operand) {
                singleSearchTerm.addOperand(this.parseConstantOperand(array.optString(i)));
                continue;
            }
            singleSearchTerm.addOperand(this.parseOperand(operand));
        }
    }

    protected ConstantOperand<?> parseConstantOperand(String s) throws NumberFormatException {
        if (s == null) {
            return ConstantOperand.NULL;
        }
        return new ConstantOperand<String>(s);
    }

    protected Operand<?> parseOperand(JSONObject operand) throws OXException {
        if (!operand.hasAndNotNull("field")) {
            throw SearchExceptionMessages.PARSING_FAILED_MISSING_FIELD.create("field");
        }
        return new ColumnOperand(operand.optString("field"));
    }

    private boolean isInteger(String s) {
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean isLong(String s) {
        try {
            Long.parseLong(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public SearchTerm<?> parseSearchTerm(JSONArray jsonArray) throws OXException {
        SearchTerm<SearchTerm<?>> retval;
        String operation;
        if (null == jsonArray) {
            return null;
        }
        try {
            operation = jsonArray.getString(0);
        }
        catch (JSONException e) {
            throw SearchExceptionMessages.PARSING_FAILED_MISSING_OPERATION.create(e, new Object[0]);
        }
        CompositeSearchTerm.CompositeOperation compositeOperation = CompositeSearchTerm.CompositeOperation.getCompositeOperation(operation);
        if (null == compositeOperation) {
            SingleSearchTerm.SingleOperation singleOperation = SingleSearchTerm.SingleOperation.getSingleOperation(operation);
            if (null == singleOperation) {
                throw SearchExceptionMessages.UNKNOWN_OPERATION.create(operation);
            }
            SingleSearchTerm singleSearchTerm = singleOperation.newInstance();
            this.parseSingleOperands(jsonArray, singleSearchTerm, singleOperation.getMaxOperands());
            retval = singleSearchTerm;
        } else {
            CompositeSearchTerm compositeSearchTerm = compositeOperation.newInstance();
            this.parseCompositeOperands(jsonArray, compositeSearchTerm, compositeOperation.getMaxTerms());
            retval = compositeSearchTerm;
        }
        return retval;
    }

    protected void parseCompositeOperands(JSONArray array, CompositeSearchTerm compositeSearchTerm, int maxTerms) throws OXException {
        int len = array.length();
        if (len < 2) {
            throw SearchExceptionMessages.PARSING_FAILED_INVALID_SEARCH_TERM.create(new Object[0]);
        }
        if (len > maxTerms + 1) {
            throw SearchExceptionMessages.PARSING_FAILED_INVALID_SEARCH_TERM.create(new Object[0]);
        }
        for (int i = 1; i < len; ++i) {
            SearchTerm<?> term = this.parseSearchTerm(array.optJSONArray(i));
            if (null == term) continue;
            compositeSearchTerm.addSearchTerm(term);
        }
    }
}

