/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax;

import com.openexchange.ajax.AJAXServlet;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.helper.BrowserDetector;
import com.openexchange.ajax.helper.DownloadUtility;
import com.openexchange.ajax.writer.ResponseWriter;
import com.openexchange.exception.OXException;
import com.openexchange.html.HtmlService;
import com.openexchange.java.Charsets;
import com.openexchange.java.Streams;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.attachment.AttachmentToken;
import com.openexchange.mail.attachment.AttachmentTokenRegistry;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.mime.ContentDisposition;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.utils.MessageUtility;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.servlet.http.Tools;
import com.openexchange.tools.stream.UnsynchronizedByteArrayInputStream;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.json.JSONException;

public class MailAttachment
extends AJAXServlet {
    private static final long serialVersionUID = -3109402774466180271L;
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(MailAttachment.class));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        Tools.disableCaching(res);
        boolean outSelected = false;
        try {
            String id = req.getParameter("id");
            if (null == id) {
                throw MailExceptionCode.MISSING_PARAM.create("id");
            }
            String saveParam = req.getParameter("save");
            boolean saveToDisk = saveParam == null || saveParam.length() == 0 ? false : Integer.parseInt(saveParam) > 0;
            String filterParam = req.getParameter("filter");
            boolean filter = Boolean.parseBoolean(filterParam) || "1".equals(filterParam);
            Tools.removeCachingHeader(res);
            AttachmentToken token = AttachmentTokenRegistry.getInstance().getToken(id);
            if (null == token) {
                throw MailExceptionCode.ATTACHMENT_EXPIRED.create();
            }
            if (token.isCheckIp() && null != token.getClientIp() && !req.getRemoteAddr().equals(token.getClientIp())) {
                AttachmentTokenRegistry.getInstance().removeToken(id);
                throw MailExceptionCode.ATTACHMENT_EXPIRED.create();
            }
            if (token.isOneTime() && null != token.getUserAgent()) {
                String requestUserAgent = req.getHeader("user-agent");
                if (null == requestUserAgent) {
                    AttachmentTokenRegistry.getInstance().removeToken(id);
                    throw MailExceptionCode.ATTACHMENT_EXPIRED.create();
                }
                if (!new BrowserDetector(token.getUserAgent()).nearlyEquals(new BrowserDetector(requestUserAgent))) {
                    AttachmentTokenRegistry.getInstance().removeToken(id);
                    throw MailExceptionCode.ATTACHMENT_EXPIRED.create();
                }
            }
            MailPart mailPart = token.getAttachment();
            File file = null;
            InputStream attachmentInputStream = null;
            try {
                int len;
                if (filter && !saveToDisk && mailPart.getContentType().isMimeType("text/htm*")) {
                    ContentType contentType = mailPart.getContentType();
                    String cs = contentType.containsCharsetParameter() ? contentType.getCharsetParameter() : MailProperties.getInstance().getDefaultMimeCharset();
                    String htmlContent = MessageUtility.readMailPart(mailPart, cs);
                    htmlContent = MessageUtility.simpleHtmlDuplicateRemoval(htmlContent);
                    HtmlService htmlService = ServerServiceRegistry.getInstance().getService(HtmlService.class);
                    attachmentInputStream = new UnsynchronizedByteArrayInputStream(MailAttachment.sanitizeHtml(htmlContent, htmlService).getBytes(Charsets.forName((String)cs)));
                } else {
                    attachmentInputStream = mailPart.getInputStream();
                }
                String fileName = mailPart.getFileName();
                if (saveToDisk) {
                    res.setContentType("application/octet-stream");
                    ContentDisposition cd = new ContentDisposition();
                    cd.setAttachment();
                    cd.addParameter("filename", fileName);
                    res.setHeader("Content-Disposition", cd.toString());
                } else {
                    String userAgent = req.getHeader("user-agent");
                    DownloadUtility.CheckedDownload checkedDownload = DownloadUtility.checkInlineDownload(attachmentInputStream, fileName, mailPart.getContentType().toString(), userAgent);
                    res.setContentType(checkedDownload.getContentType());
                    res.setHeader("Content-Disposition", checkedDownload.getContentDisposition());
                    attachmentInputStream = checkedDownload.getInputStream();
                }
                Tools.removeCachingHeader(res);
                ServletOutputStream out = res.getOutputStream();
                outSelected = true;
                int buflen = 65535;
                byte[] buffer = new byte[65535];
                while ((len = attachmentInputStream.read(buffer, 0, 65535)) > 0) {
                    out.write(buffer, 0, len);
                }
                out.flush();
            }
            finally {
                token.close();
                Streams.close((Closeable)attachmentInputStream);
                if (null != file) {
                    file.delete();
                }
            }
        }
        catch (OXException e) {
            MailAttachment.callbackError(res, outSelected, e);
        }
        catch (Exception e) {
            OXException exc = MailAttachment.getWrappingOXException(e);
            LOG.error((Object)exc.getMessage(), (Throwable)exc);
            MailAttachment.callbackError(res, outSelected, exc);
        }
    }

    private static boolean isMSIEOnWindows(String userAgent) {
        BrowserDetector browserDetector = new BrowserDetector(userAgent);
        return browserDetector.isMSIE() && browserDetector.isWindows();
    }

    protected static final OXException getWrappingOXException(Exception cause) {
        if (LOG.isWarnEnabled()) {
            StringBuilder warnBuilder = new StringBuilder(140);
            warnBuilder.append("An unexpected exception occurred, which is going to be wrapped for proper display.\n");
            warnBuilder.append("For safety reason its original content is display here.");
            LOG.warn((Object)warnBuilder.toString(), (Throwable)cause);
        }
        return new OXException((Throwable)cause);
    }

    private static void callbackError(HttpServletResponse resp, boolean outSelected, OXException e) {
        try {
            PrintWriter writer;
            resp.setContentType("text/html; charset=UTF-8");
            if (outSelected) {
                Tools.disableCaching(resp);
                writer = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)resp.getOutputStream(), resp.getCharacterEncoding())), true);
            } else {
                writer = resp.getWriter();
            }
            resp.setHeader("Content-Disposition", null);
            Response response = new Response();
            response.setException(e);
            ((Writer)writer).write(MailAttachment.substituteJS(ResponseWriter.getJSON(response).toString(), "error"));
            ((Writer)writer).flush();
        }
        catch (UnsupportedEncodingException uee) {
            uee.initCause(e);
            LOG.error((Object)uee.getMessage(), (Throwable)uee);
        }
        catch (IOException ioe) {
            ioe.initCause(e);
            LOG.error((Object)ioe.getMessage(), (Throwable)ioe);
        }
        catch (IllegalStateException ise) {
            ise.initCause(e);
            LOG.error((Object)ise.getMessage(), (Throwable)ise);
        }
        catch (JSONException je) {
            je.initCause((Throwable)e);
            LOG.error((Object)je.getMessage(), (Throwable)je);
        }
    }

    private static String sanitizeHtml(String htmlContent, HtmlService htmlService) {
        return htmlService.sanitize(htmlContent, null, false, null, null);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        res.setContentType("text/html; charset=UTF-8");
        res.setStatus(405);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        res.setContentType("text/html; charset=UTF-8");
        res.setStatus(405);
    }
}

