/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.java;

import com.openexchange.java.Charsets;
import com.openexchange.java.StringAllocator;

public final class HTMLDetector {
    private HTMLDetector() {
    }

    public static boolean containsHTMLTags(byte[] sequence) {
        if (sequence == null) {
            throw new NullPointerException();
        }
        if (HTMLDetector.containsHTMLTag(sequence, "html")) {
            return true;
        }
        if (HTMLDetector.containsHTMLTag(sequence, "head")) {
            return true;
        }
        if (HTMLDetector.containsHTMLTag(sequence, "body")) {
            return true;
        }
        if (HTMLDetector.containsHTMLTag(sequence, "script")) {
            return true;
        }
        if (HTMLDetector.containsIgnoreCase(sequence, "javascript")) {
            return true;
        }
        if (HTMLDetector.containsIgnoreCase(sequence, "<img")) {
            return true;
        }
        if (HTMLDetector.containsIgnoreCase(sequence, "<br>")) {
            return true;
        }
        return HTMLDetector.containsIgnoreCase(sequence, "<p>");
    }

    public static boolean containsHTMLTags(byte[] sequence, int off, int len) {
        byte[] b;
        if (sequence == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > sequence.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (off > 0 || sequence.length != len) {
            b = new byte[len];
            System.arraycopy(sequence, off, b, 0, len);
        } else {
            b = sequence;
        }
        if (HTMLDetector.containsHTMLTag(b, "html")) {
            return true;
        }
        if (HTMLDetector.containsHTMLTag(b, "head")) {
            return true;
        }
        if (HTMLDetector.containsHTMLTag(b, "body")) {
            return true;
        }
        if (HTMLDetector.containsHTMLTag(b, "script")) {
            return true;
        }
        if (HTMLDetector.containsIgnoreCase(b, "javascript")) {
            return true;
        }
        if (HTMLDetector.containsIgnoreCase(b, "<img")) {
            return true;
        }
        if (HTMLDetector.containsIgnoreCase(b, "<br>")) {
            return true;
        }
        return HTMLDetector.containsIgnoreCase(b, "<p>");
    }

    public static boolean containsHTMLTag(byte[] sequence, String tag) {
        if (sequence == null) {
            throw new NullPointerException();
        }
        return HTMLDetector.containsIgnoreCase(sequence, new StringAllocator(tag.length() + 2).append('<').append(tag).append('>').toString());
    }

    public static boolean containsHTMLTag(byte[] sequence, int off, int len, String tag) {
        byte[] b;
        if (sequence == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > sequence.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (off > 0 || sequence.length != len) {
            b = new byte[len];
            System.arraycopy(sequence, off, b, 0, len);
        } else {
            b = sequence;
        }
        return HTMLDetector.containsIgnoreCase(b, new StringAllocator(tag.length() + 2).append('<').append(tag).append('>').toString());
    }

    private static boolean containsIgnoreCase(byte[] sequence, String str) {
        if (HTMLDetector.indexOf(sequence, Charsets.toAsciiBytes(HTMLDetector.toLowerCase(str)), 0, sequence.length) != -1) {
            return true;
        }
        return HTMLDetector.indexOf(sequence, Charsets.toAsciiBytes(HTMLDetector.toUpperCase(str)), 0, sequence.length) != -1;
    }

    private static int indexOf(byte[] data, byte[] pattern, int beginIndex, int endIndex) {
        if (beginIndex < 0 || beginIndex > data.length) {
            throw new IndexOutOfBoundsException(Integer.toString(beginIndex));
        }
        if (endIndex < 0 || endIndex > data.length) {
            throw new IndexOutOfBoundsException(Integer.toString(endIndex));
        }
        if (beginIndex > endIndex) {
            throw new IndexOutOfBoundsException(Integer.toString(endIndex - beginIndex));
        }
        int[] failure = HTMLDetector.computeFailure(pattern);
        if (failure == null) {
            throw new IllegalArgumentException("pattern is null");
        }
        int j = 0;
        if (data.length == 0) {
            return -1;
        }
        for (int i = beginIndex; i < endIndex; ++i) {
            while (j > 0 && pattern[j] != data[i]) {
                j = failure[j - 1];
            }
            if (pattern[j] == data[i]) {
                ++j;
            }
            if (j != pattern.length) continue;
            return i - pattern.length + 1;
        }
        return -1;
    }

    private static int[] computeFailure(byte[] pattern) {
        if (pattern == null) {
            return null;
        }
        int[] failure = new int[pattern.length];
        int j = 0;
        for (int i = 1; i < pattern.length; ++i) {
            while (j > 0 && pattern[j] != pattern[i]) {
                j = failure[j - 1];
            }
            if (pattern[j] == pattern[i]) {
                // empty if block
            }
            failure[i] = ++j;
        }
        return failure;
    }

    private static String toLowerCase(CharSequence chars) {
        if (null == chars) {
            return null;
        }
        int length = chars.length();
        StringAllocator builder = new StringAllocator(length);
        for (int i = 0; i < length; ++i) {
            char c = chars.charAt(i);
            builder.append(c >= 'A' && c <= 'Z' ? (char)(c ^ 0x20) : c);
        }
        return builder.toString();
    }

    private static String toUpperCase(CharSequence chars) {
        if (null == chars) {
            return null;
        }
        int length = chars.length();
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = chars.charAt(i);
            builder.append(c >= 'a' && c <= 'z' ? (char)(c & 0x5F) : c);
        }
        return builder.toString();
    }
}

