/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.log;

import com.openexchange.java.StringAllocator;
import com.openexchange.log.ForceLog;
import com.openexchange.log.LogProperties;
import com.openexchange.log.LogPropertyName;
import com.openexchange.log.Props;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;

public class PropertiesAppendingLogWrapper
implements Log {
    private final String lineSeparator = System.getProperty("line.separator");
    private final Log delegate;

    protected PropertiesAppendingLogWrapper(Log delegate) {
        this.delegate = delegate;
    }

    public void debug(Object message, Throwable t) {
        this.delegate.debug((Object)this.appendProperties(message == null ? null : message.toString(), LogPropertyName.LogLevel.DEBUG), t);
    }

    public void debug(Object message) {
        this.delegate.debug((Object)this.appendProperties(message == null ? null : message.toString(), LogPropertyName.LogLevel.DEBUG));
    }

    public void error(Object message, Throwable t) {
        this.delegate.error((Object)this.appendProperties(message == null ? null : message.toString(), LogPropertyName.LogLevel.ERROR), t);
    }

    public void error(Object message) {
        this.delegate.error((Object)this.appendProperties(message == null ? null : message.toString(), LogPropertyName.LogLevel.ERROR));
    }

    public void fatal(Object message, Throwable t) {
        this.delegate.fatal((Object)this.appendProperties(message == null ? null : message.toString(), LogPropertyName.LogLevel.FATAL), t);
    }

    public void fatal(Object message) {
        this.delegate.fatal((Object)this.appendProperties(message == null ? null : message.toString(), LogPropertyName.LogLevel.FATAL));
    }

    public void info(Object message, Throwable t) {
        this.delegate.info((Object)this.appendProperties(message == null ? null : message.toString(), LogPropertyName.LogLevel.INFO), t);
    }

    public void info(Object message) {
        this.delegate.info((Object)this.appendProperties(message == null ? null : message.toString(), LogPropertyName.LogLevel.INFO));
    }

    public void trace(Object message, Throwable t) {
        this.delegate.trace((Object)this.appendProperties(message == null ? null : message.toString(), LogPropertyName.LogLevel.TRACE), t);
    }

    public void trace(Object message) {
        this.delegate.trace((Object)this.appendProperties(message == null ? null : message.toString(), LogPropertyName.LogLevel.TRACE));
    }

    public void warn(Object message, Throwable t) {
        this.delegate.warn((Object)this.appendProperties(message == null ? null : message.toString(), LogPropertyName.LogLevel.WARNING), t);
    }

    public void warn(Object message) {
        this.delegate.warn((Object)this.appendProperties(message == null ? null : message.toString(), LogPropertyName.LogLevel.WARNING));
    }

    public boolean isDebugEnabled() {
        return this.delegate.isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return this.delegate.isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return this.delegate.isFatalEnabled();
    }

    public boolean isInfoEnabled() {
        return this.delegate.isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this.delegate.isTraceEnabled();
    }

    public boolean isWarnEnabled() {
        return this.delegate.isWarnEnabled();
    }

    public String appendProperties(String message, LogPropertyName.LogLevel logLevel) {
        Object value;
        LogProperties.Name propertyName;
        Set alreadyLogged;
        if (!LogProperties.isEnabled()) {
            return message;
        }
        Props logProps = LogProperties.optLogProperties();
        if (logProps == null) {
            return message;
        }
        Map<LogProperties.Name, Object> properties = logProps.getMap();
        if (properties == null) {
            return message;
        }
        TreeMap<String, String> sorted = new TreeMap<String, String>();
        boolean isEmpty = true;
        List<LogPropertyName> names = LogProperties.getPropertyNames();
        if (names.isEmpty()) {
            alreadyLogged = Collections.emptySet();
        } else {
            alreadyLogged = EnumSet.noneOf(LogProperties.Name.class);
            for (LogPropertyName logPropertyName : names) {
                if (!logPropertyName.implies(logLevel)) continue;
                propertyName = logPropertyName.getPropertyName();
                alreadyLogged.add(propertyName);
                value = properties.get((Object)propertyName);
                if (null == value) continue;
                sorted.put(propertyName.getName(), value.toString());
                isEmpty = false;
            }
        }
        for (Map.Entry entry : properties.entrySet()) {
            propertyName = (LogProperties.Name)((Object)entry.getKey());
            if (alreadyLogged.contains((Object)propertyName) || !((value = entry.getValue()) instanceof ForceLog)) continue;
            sorted.put(propertyName.getName(), value.toString());
            isEmpty = false;
        }
        StringAllocator sb = new StringAllocator(256);
        if (!isEmpty) {
            String lineSeparator = this.lineSeparator;
            for (Map.Entry entry : sorted.entrySet()) {
                sb.append(lineSeparator).append((String)entry.getKey()).append('=').append((String)entry.getValue());
            }
            sb.deleteCharAt(0).append(lineSeparator).append(lineSeparator);
        }
        sb.append(message);
        return sb.toString();
    }
}

