/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml.framework;

import com.openexchange.configuration.WebDAVConfig;
import com.openexchange.exception.OXException;
import com.openexchange.webdav.xml.folder.FolderTools;
import com.openexchange.webdav.xml.framework.AbstractWebDAVResponse;
import com.openexchange.webdav.xml.framework.Executor;
import com.openexchange.webdav.xml.framework.WebDAVRequest;
import com.openexchange.webdav.xml.framework.WebDAVSession;
import com.openexchange.webdav.xml.user.GroupUserTools;
import java.io.IOException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.jdom2.JDOMException;

public class WebDAVClient {
    private WebDAVSession session;
    private FolderTools folderTools;
    private GroupUserTools groupUserTools;

    public WebDAVClient(WebDAVSession session) {
        this.session = session;
    }

    public WebDAVClient(User user) throws OXException {
        this(new WebDAVSession());
        WebDAVConfig.init();
        String login = WebDAVConfig.getProperty(user.getLogin());
        String password = WebDAVConfig.getProperty(user.getPassword());
        this.setAuth(login, password);
    }

    public WebDAVClient(String login, String password) {
        this(new WebDAVSession());
        this.setAuth(login, password);
    }

    public final void setAuth(String login, String password) {
        HttpClient client = this.session.getClient();
        client.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(login, password));
    }

    public WebDAVSession getSession() {
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.logout();
        }
        finally {
            super.finalize();
        }
    }

    public void logout() {
        this.session = new WebDAVSession();
    }

    public <T extends AbstractWebDAVResponse> T execute(WebDAVRequest<T> request) throws IOException, JDOMException, OXException, OXException {
        return Executor.execute(this, request);
    }

    public <T extends AbstractWebDAVResponse> T execute(String host, WebDAVRequest<T> request) throws IOException, JDOMException, OXException, OXException {
        if (null == host) {
            return this.execute(request);
        }
        return Executor.execute(this, host, request);
    }

    public FolderTools getFolderTools() {
        if (null == this.folderTools) {
            this.folderTools = new FolderTools(this);
        }
        return this.folderTools;
    }

    public GroupUserTools getGroupUserTools() {
        if (null == this.groupUserTools) {
            this.groupUserTools = new GroupUserTools(this);
        }
        return this.groupUserTools;
    }

    public static enum User {
        User1(WebDAVConfig.Property.LOGIN, WebDAVConfig.Property.PASSWORD),
        User2(WebDAVConfig.Property.SECONDUSER, WebDAVConfig.Property.PASSWORD);

        private WebDAVConfig.Property login;
        private WebDAVConfig.Property password;

        private User(WebDAVConfig.Property login, WebDAVConfig.Property password) {
            this.login = login;
            this.password = password;
        }

        public WebDAVConfig.Property getLogin() {
            return this.login;
        }

        public WebDAVConfig.Property getPassword() {
            return this.password;
        }
    }
}

