/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml.framework;

import com.openexchange.configuration.WebDAVConfig;
import com.openexchange.exception.OXException;
import com.openexchange.test.TestException;
import com.openexchange.webdav.xml.framework.AbstractWebDAVParser;
import com.openexchange.webdav.xml.framework.AbstractWebDAVResponse;
import com.openexchange.webdav.xml.framework.WebDAVClient;
import com.openexchange.webdav.xml.framework.WebDAVRequest;
import com.openexchange.webdav.xml.request.PropFindMethod;
import java.io.IOException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.BasicScheme;
import org.apache.commons.httpclient.methods.PutMethod;
import org.jdom2.JDOMException;

public final class Executor {
    private Executor() {
    }

    public static <T extends AbstractWebDAVResponse> T execute(WebDAVClient client, WebDAVRequest<T> request) throws IOException, JDOMException, OXException, OXException {
        return Executor.execute(client, WebDAVConfig.getProperty(WebDAVConfig.Property.PROTOCOL) + "://" + WebDAVConfig.getProperty(WebDAVConfig.Property.HOSTNAME), request);
    }

    static <T extends AbstractWebDAVResponse> T execute(WebDAVClient client, String host, WebDAVRequest<T> request) throws IOException, JDOMException, OXException, OXException {
        PropFindMethod method;
        String urlString = host + request.getServletPath();
        switch (request.getMethod()) {
            case PROPFIND: {
                PropFindMethod propFind = new PropFindMethod(urlString);
                propFind.setRequestEntity(request.getEntity());
                method = propFind;
                break;
            }
            case PUT: {
                PutMethod put = new PutMethod(urlString);
                put.setRequestEntity(request.getEntity());
                method = put;
                break;
            }
            default: {
                throw new TestException("Unknown method.");
            }
        }
        method.setDoAuthentication(true);
        method.getHostAuthState().setAuthScheme((AuthScheme)new BasicScheme());
        int status = client.getSession().getClient().executeMethod((HttpMethod)method);
        AbstractWebDAVParser<T> parser = request.getParser();
        parser.checkResponse(status);
        return parser.parse((HttpMethodBase)method);
    }
}

