/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml.appointment;

import com.openexchange.exception.OXException;
import com.openexchange.group.Group;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.GroupParticipant;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.ResourceParticipant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.resource.Resource;
import com.openexchange.webdav.xml.AppointmentTest;
import com.openexchange.webdav.xml.GroupUserTest;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class UpdateTest
extends AppointmentTest {
    public UpdateTest(String name) {
        super(name);
    }

    public void testUpdate() throws Exception {
        Appointment appointmentObj = this.createAppointmentObject("testUpdateAppointment");
        appointmentObj.setIgnoreConflicts(true);
        int objectId = UpdateTest.insertAppointment(this.webCon, appointmentObj, "http://" + this.hostName, this.login, this.password, this.context);
        appointmentObj = this.createAppointmentObject("testUpdateAppointment2");
        appointmentObj.setLocation(null);
        appointmentObj.setShownAs(4);
        appointmentObj.setIgnoreConflicts(true);
        UpdateTest.updateAppointment(this.webCon, appointmentObj, objectId, this.appointmentFolderId, "http://" + this.hostName, this.login, this.password, this.context);
        Appointment loadAppointment = UpdateTest.loadAppointment(this.getWebConversation(), objectId, this.appointmentFolderId, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        UpdateTest.compareObject(appointmentObj, loadAppointment);
        int[][] objectIdAndFolderId = new int[][]{{objectId, this.appointmentFolderId}};
        UpdateTest.deleteAppointment(this.webCon, objectIdAndFolderId, "http://" + this.hostName, this.login, this.password, this.context);
    }

    public void testUpdateAppointmentRemoveAlarm() throws Exception {
        Appointment appointmentObj = this.createAppointmentObject("testUpdateAppointmentRemoveAlarm");
        appointmentObj.setIgnoreConflicts(true);
        appointmentObj.setAlarm(45);
        int objectId = UpdateTest.insertAppointment(this.webCon, appointmentObj, "http://" + this.hostName, this.login, this.password, this.context);
        appointmentObj = this.createAppointmentObject("testUpdateAppointmentRemoveAlarm");
        appointmentObj.setLocation(null);
        appointmentObj.setShownAs(4);
        appointmentObj.setIgnoreConflicts(true);
        appointmentObj.setAlarmFlag(false);
        UpdateTest.updateAppointment(this.webCon, appointmentObj, objectId, this.appointmentFolderId, "http://" + this.hostName, this.login, this.password, this.context);
        Appointment loadAppointment = UpdateTest.loadAppointment(this.getWebConversation(), objectId, this.appointmentFolderId, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        UpdateTest.compareObject(appointmentObj, loadAppointment);
        int[][] objectIdAndFolderId = new int[][]{{objectId, this.appointmentFolderId}};
        UpdateTest.deleteAppointment(this.webCon, objectIdAndFolderId, "http://" + this.hostName, this.login, this.password, this.context);
    }

    public void testUpdateConcurentConflict() throws Exception {
        Appointment appointmentObj = this.createAppointmentObject("testUpdateAppointmentConcurentConflict");
        appointmentObj.setIgnoreConflicts(true);
        int objectId = UpdateTest.insertAppointment(this.webCon, appointmentObj, "http://" + this.hostName, this.login, this.password, this.context);
        appointmentObj = this.createAppointmentObject("testUpdateAppointmentConcurentConflict2");
        appointmentObj.setLocation(null);
        appointmentObj.setShownAs(4);
        appointmentObj.setIgnoreConflicts(true);
        try {
            UpdateTest.updateAppointment(this.webCon, appointmentObj, objectId, this.appointmentFolderId, new Date(0L), "http://" + this.hostName, this.login, this.password, this.context);
            UpdateTest.fail((String)"expected concurent modification exception!");
        }
        catch (OXException exc) {
            UpdateTest.assertExceptionMessage(exc.getDisplayMessage(Locale.ENGLISH), 1000);
        }
        int[][] objectIdAndFolderId = new int[][]{{objectId, this.appointmentFolderId}};
        UpdateTest.deleteAppointment(this.webCon, objectIdAndFolderId, "http://" + this.hostName, this.login, this.password, this.context);
    }

    public void testUpdateNotFound() throws Exception {
        Appointment appointmentObj = this.createAppointmentObject("testUpdateAppointmentNotFound");
        appointmentObj.setIgnoreConflicts(true);
        int objectId = UpdateTest.insertAppointment(this.webCon, appointmentObj, "http://" + this.hostName, this.login, this.password, this.context);
        appointmentObj = this.createAppointmentObject("testUpdateAppointmentNotFound");
        appointmentObj.setLocation(null);
        appointmentObj.setShownAs(4);
        appointmentObj.setIgnoreConflicts(true);
        try {
            UpdateTest.updateAppointment(this.webCon, appointmentObj, objectId + 1000, this.appointmentFolderId, new Date(0L), "http://" + this.hostName, this.login, this.password, this.context);
            UpdateTest.fail((String)"expected object not found exception!");
        }
        catch (OXException exc) {
            UpdateTest.assertExceptionMessage(exc.getDisplayMessage(Locale.ENGLISH), 1001);
        }
        int[][] objectIdAndFolderId = new int[][]{{objectId, this.appointmentFolderId}};
        UpdateTest.deleteAppointment(this.webCon, objectIdAndFolderId, "http://" + this.hostName, this.login, this.password, this.context);
    }

    public void testUpdateAppointmentWithParticipants() throws Exception {
        Appointment appointmentObj = this.createAppointmentObject("testUpdateAppointmentWithParticipants");
        appointmentObj.setIgnoreConflicts(true);
        int objectId = UpdateTest.insertAppointment(this.webCon, appointmentObj, "http://" + this.hostName, this.login, this.password, this.context);
        appointmentObj = this.createAppointmentObject("testUpdateAppointmentWithParticipants");
        int userParticipantId = GroupUserTest.getUserId(this.getWebConversation(), "http://" + this.getHostName(), this.userParticipant3, this.getPassword(), this.context);
        UpdateTest.assertTrue((String)"user participant not found", (userParticipantId != -1 ? 1 : 0) != 0);
        Group[] groupArray = GroupUserTest.searchGroup(this.webCon, this.groupParticipant, new Date(0L), "http://" + this.hostName, this.login, this.password, this.context);
        UpdateTest.assertTrue((String)"group array size is not > 0", (groupArray.length > 0 ? 1 : 0) != 0);
        int groupParticipantId = groupArray[0].getIdentifier();
        Resource[] resourceArray = GroupUserTest.searchResource(this.webCon, this.resourceParticipant, new Date(0L), "http://" + this.hostName, this.login, this.password, this.context);
        UpdateTest.assertTrue((String)"resource array size is not > 0", (resourceArray.length > 0 ? 1 : 0) != 0);
        int resourceParticipantId = resourceArray[0].getIdentifier();
        Participant[] participants = new Participant[4];
        participants[0] = new UserParticipant();
        participants[0].setIdentifier(this.userId);
        participants[1] = new UserParticipant();
        participants[1].setIdentifier(userParticipantId);
        participants[2] = new GroupParticipant();
        participants[2].setIdentifier(groupParticipantId);
        participants[3] = new ResourceParticipant();
        participants[3].setIdentifier(resourceParticipantId);
        appointmentObj.setParticipants(participants);
        appointmentObj.setIgnoreConflicts(true);
        UpdateTest.updateAppointment(this.webCon, appointmentObj, objectId, this.appointmentFolderId, "http://" + this.hostName, this.login, this.password, this.context);
        int[][] objectIdAndFolderId = new int[][]{{objectId, this.appointmentFolderId}};
        UpdateTest.deleteAppointment(this.webCon, objectIdAndFolderId, "http://" + this.hostName, this.login, this.password, this.context);
    }

    public void testUpdateRecurrenceWithDatePosition() throws Exception {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(TimeZone.getTimeZone("UTC"));
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        Date until = new Date(c.getTimeInMillis() + 1296000000L);
        int changeExceptionPosition = 3;
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testUpdateRecurrence");
        appointmentObj.setStartDate(this.startTime);
        appointmentObj.setEndDate(this.endTime);
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(this.appointmentFolderId);
        appointmentObj.setRecurrenceType(1);
        appointmentObj.setInterval(1);
        appointmentObj.setUntil(until);
        appointmentObj.setIgnoreConflicts(true);
        int objectId = UpdateTest.insertAppointment(this.getWebConversation(), appointmentObj, "http://" + this.getHostName(), this.login, this.password, this.context);
        appointmentObj.setObjectID(objectId);
        Appointment loadAppointment = UpdateTest.loadAppointment(this.getWebConversation(), objectId, this.appointmentFolderId, "http://" + this.getHostName(), this.login, this.password, this.context);
        UpdateTest.compareObject(appointmentObj, loadAppointment);
        appointmentObj = new Appointment();
        appointmentObj.setTitle("testUpdateRecurrence - exception");
        appointmentObj.setStartDate(new Date(this.startTime.getTime() + 3600000L));
        appointmentObj.setEndDate(new Date(this.endTime.getTime() + 3600000L));
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(this.appointmentFolderId);
        appointmentObj.setRecurrenceDatePosition(new Date(c.getTimeInMillis() + 259200000L));
        appointmentObj.setIgnoreConflicts(true);
        int newObjectId = UpdateTest.updateAppointment(this.getWebConversation(), appointmentObj, objectId, this.appointmentFolderId, "http://" + this.getHostName(), this.login, this.password, this.context);
        appointmentObj.setObjectID(newObjectId);
        UpdateTest.assertFalse((String)"object id of the update is equals with the old object id", (newObjectId == objectId ? 1 : 0) != 0);
        loadAppointment = UpdateTest.loadAppointment(this.getWebConversation(), newObjectId, this.appointmentFolderId, "http://" + this.getHostName(), this.login, this.password, this.context);
        UpdateTest.compareObject(appointmentObj, loadAppointment);
        UpdateTest.deleteAppointment(this.getWebConversation(), new int[][]{{objectId, this.appointmentFolderId}}, "http://" + this.getHostName(), this.login, this.password, this.context);
    }

    public void testShouldExtendSeriesFromLimitedToEndless() throws OXException, Exception {
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testUpdateRecurrence");
        appointmentObj.setStartDate(this.startTime);
        appointmentObj.setEndDate(this.endTime);
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(this.appointmentFolderId);
        appointmentObj.setRecurrenceType(1);
        appointmentObj.setInterval(1);
        appointmentObj.setOccurrence(12);
        appointmentObj.setIgnoreConflicts(true);
        int objectId = UpdateTest.insertAppointment(this.getWebConversation(), appointmentObj, "http://" + this.getHostName(), this.login, this.password, this.context);
        appointmentObj.setObjectID(objectId);
        Appointment loadAppointment = UpdateTest.loadAppointment(this.getWebConversation(), objectId, this.appointmentFolderId, "http://" + this.getHostName(), this.login, this.password, this.context);
        appointmentObj = new Appointment();
        appointmentObj.setObjectID(objectId);
        appointmentObj.setTitle("testUpdateRecurrence");
        appointmentObj.setStartDate(this.startTime);
        appointmentObj.setEndDate(this.endTime);
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(this.appointmentFolderId);
        appointmentObj.setRecurrenceType(1);
        appointmentObj.setInterval(1);
        appointmentObj.setIgnoreConflicts(true);
        UpdateTest.updateAppointment(this.getWebConversation(), appointmentObj, objectId, this.appointmentFolderId, "http://" + this.getHostName(), this.login, this.password, this.context);
        loadAppointment = UpdateTest.loadAppointment(this.getWebConversation(), objectId, this.appointmentFolderId, "http://" + this.getHostName(), this.login, this.password, this.context);
        UpdateTest.compareObject(appointmentObj, loadAppointment);
        UpdateTest.deleteAppointment(this.getWebConversation(), new int[][]{{objectId, this.appointmentFolderId}}, "http://" + this.getHostName(), this.login, this.password, this.context);
    }
}

