/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.test.fixtures;

import com.openexchange.test.fixtures.InfoItem;
import com.openexchange.test.fixtures.SimpleCredentials;
import java.io.File;

public class Document {
    private String path;
    private File file;
    private String mimeType;
    private String comments;
    private SimpleCredentials createdBy;
    private InfoItem parent;
    private final File datapath;
    private Object seleniumDataPath;
    private Object seleniumSeparator;

    public Document(File datapath) {
        this(null, datapath);
    }

    public Document(InfoItem parent, File datapath) {
        this.datapath = datapath;
        this.setParent(parent);
    }

    public boolean containsFile() {
        return null != this.getFile();
    }

    public String getName() {
        if (this.containsFile()) {
            return this.getFile().getName();
        }
        return null;
    }

    public File getFile() {
        String localPath;
        if (null == this.file && null != (localPath = this.getLocalPath())) {
            this.file = new File(localPath).getAbsoluteFile();
        }
        return this.file;
    }

    public boolean containsMimeType() {
        return null != this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public long getSize() {
        File file = this.getFile();
        return null == file ? 0L : file.length();
    }

    public boolean containsComments() {
        return null != this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public String getComments() {
        return this.comments;
    }

    public boolean containsCreatedBy() {
        return null != this.createdBy;
    }

    public void setCreatedBy(SimpleCredentials createdBy) {
        this.createdBy = createdBy;
    }

    public SimpleCredentials getCreatedBy() {
        return this.createdBy;
    }

    public void setSeleniumConfiguration(String seleniumDataPath, String seleniumSeparator) {
        this.seleniumDataPath = seleniumDataPath;
        this.seleniumSeparator = seleniumSeparator;
    }

    public boolean containsParent() {
        return null != this.parent;
    }

    public void setParent(InfoItem parent) {
        this.parent = parent;
    }

    public InfoItem getParent() {
        return this.parent;
    }

    public boolean isCurrent() {
        if (this.containsParent()) {
            return this.equals(this.parent.getCurrentVersion());
        }
        return false;
    }

    public int getVersionNumber() {
        if (this.containsParent()) {
            Document[] versions = this.parent.getVersions();
            for (int i = 0; i < versions.length; ++i) {
                if (!this.equals(versions[i])) continue;
                return i + 1;
            }
        }
        return 0;
    }

    public String getLocalPath() {
        if (this.containsPath()) {
            return String.format("%s%s%s", this.datapath, Character.valueOf(File.separatorChar), this.getPath().replaceAll("[/\\\\]+", "\\" + File.separatorChar));
        }
        return null;
    }

    public String getRemotePath() {
        if (this.seleniumDataPath == null) {
            throw new UnsupportedOperationException("This object is not configured for selenium operations.");
        }
        if (this.containsPath()) {
            return String.format("%s%s%s", this.seleniumDataPath, this.seleniumSeparator, this.getPath().replaceAll("[/\\\\]+", "\\" + this.seleniumSeparator));
        }
        return null;
    }

    public boolean containsPath() {
        return null != this.path;
    }

    public void setPath(String relativePath) {
        this.path = relativePath;
    }

    public String getPath() {
        return this.path;
    }

    public File getDatapath() {
        return this.datapath;
    }

    public String toString() {
        return this.containsPath() ? this.getPath() : super.toString();
    }
}

