/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.structure;

import com.openexchange.mail.AbstractMailTest;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.structure.StructureHandler;
import com.openexchange.mail.structure.StructureMailMessageParser;
import com.openexchange.mail.structure.handler.MIMEStructureHandler;
import org.json.JSONArray;
import org.json.JSONObject;

public class Bug18846StructureTest
extends AbstractMailTest {
    private static final byte[] SOURCE = "Date: Wed, 18 May 2011 12:05:12 +0200 (CEST)\nFrom: me@somewhere.com\nTo: you@another.org\nMessage-ID: <1003957407.805.1305713112926>\nSubject: Bug #18846 Test\nMIME-Version: 1.0\nContent-Type: multipart/mixed; \n    boundary=\"----=_Part_803_1839345999.1305713112873\"\nX-Priority: 3\nImportance: Medium\n\n------=_Part_803_1839345999.1305713112873\nMIME-Version: 1.0\nContent-Type: text/plain; charset=UTF-8\nContent-Transfer-Encoding: quoted-printable\n\nSome mail text.\n\n------=_Part_803_1839345999.1305713112873\nContent-Type: message/rfc822; name=part.eml\nContent-Disposition: INLINE; filename=part.eml\n\nContent-Type: message/rfc822\n\nDate: Tue, 26 Apr 2011 09:29:24 +0200 (CEST)\nFrom: jane@bar.com\nTo: christine@domain.com\nMessage-ID: <675680366.104.1303802964881>\nSubject: blabla\nMIME-Version: 1.0\nContent-Type: text/plain; charset=UTF-8\nX-Priority: 3\nImportance: Medium\n\nlalalalalalala\n\n------=_Part_803_1839345999.1305713112873--\n".getBytes();

    public Bug18846StructureTest() {
    }

    public Bug18846StructureTest(String name) {
        super(name);
    }

    public void testMIMEStructure() {
        try {
            this.getSession();
            MailMessage mail = MimeMessageConverter.convertMessage((byte[])SOURCE);
            MIMEStructureHandler handler = new MIMEStructureHandler(-1L);
            new StructureMailMessageParser().parseMailMessage(mail, (StructureHandler)handler);
            JSONObject jsonMailObject = handler.getJSONMailObject();
            Bug18846StructureTest.assertNotNull((String)"Structured JSON mail object is null.", (Object)jsonMailObject);
            Object bodyObject = jsonMailObject.opt("body");
            Bug18846StructureTest.assertNotNull((String)"Missing mail body.", (Object)bodyObject);
            Bug18846StructureTest.assertTrue((String)"Body object is not a JSON array.", (boolean)(bodyObject instanceof JSONArray));
            JSONArray jsonBodyArray = (JSONArray)bodyObject;
            Bug18846StructureTest.assertTrue((String)"Unexpected array length.", (jsonBodyArray.length() == 2 ? 1 : 0) != 0);
            JSONObject bodyPart = jsonBodyArray.getJSONObject(1);
            String contentType = bodyPart.getJSONObject("headers").getJSONObject("content-type").getString("type");
            Bug18846StructureTest.assertEquals((String)("Unexpected Content-Type: " + contentType), (String)"message/rfc822", (String)contentType);
            JSONObject nestedMail = bodyPart.getJSONObject("body");
            String contentType2 = nestedMail.getJSONObject("headers").getJSONObject("content-type").getString("type");
            Bug18846StructureTest.assertEquals((String)("Unexpected Content-Type: " + contentType2), (String)"message/rfc822", (String)contentType2);
            JSONObject nestedNestedMail = nestedMail.getJSONObject("body");
            String contentType3 = nestedNestedMail.getJSONObject("headers").getJSONObject("content-type").getString("type");
            Bug18846StructureTest.assertEquals((String)("Unexpected Content-Type: " + contentType3), (String)"text/plain", (String)contentType3);
        }
        catch (Exception e) {
            e.printStackTrace();
            Bug18846StructureTest.fail((String)e.getMessage());
        }
    }
}

