/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.folderstorage;

import com.openexchange.exception.OXException;
import com.openexchange.mail.AbstractMailTest;
import com.openexchange.mail.MailProviderRegistry;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.dataobjects.MailFolder;
import com.openexchange.mail.dataobjects.MailFolderDescription;
import com.openexchange.mail.permission.MailPermission;
import com.openexchange.session.Session;
import com.openexchange.sessiond.impl.SessionObject;

public final class MailFolderSpecialCharsTest
extends AbstractMailTest {
    private static final String INBOX = "INBOX";

    public MailFolderSpecialCharsTest() {
    }

    public MailFolderSpecialCharsTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testFolderCreateAndSubfolders() throws OXException {
        MailAccess mailAccess;
        block15: {
            SessionObject session = this.getSession();
            mailAccess = MailAccess.getInstance((Session)session);
            mailAccess.connect();
            String fullname = null;
            try {
                String parentFullname = null;
                MailFolder inbox = mailAccess.getFolderStorage().getFolder(INBOX);
                String invalidName = "Foo" + inbox.getSeparator() + "Bar";
                if (inbox.isHoldsFolders()) {
                    fullname = inbox.getFullname() + inbox.getSeparator() + invalidName;
                    parentFullname = INBOX;
                } else {
                    fullname = invalidName;
                    parentFullname = "default";
                }
                MailFolderDescription mfd = new MailFolderDescription();
                mfd.setExists(false);
                mfd.setParentFullname(parentFullname);
                mfd.setSeparator(inbox.getSeparator());
                mfd.setSubscribed(false);
                mfd.setName(invalidName);
                MailPermission p = MailProviderRegistry.getMailProviderBySession((Session)session, (int)0).createNewMailPermission((Session)session, 0);
                p.setEntity(this.getUser());
                p.setAllPermission(128, 128, 128, 128);
                p.setFolderAdmin(true);
                p.setGroupPermission(false);
                mfd.addPermission(p);
                OXException me = null;
                try {
                    mailAccess.getFolderStorage().createFolder(mfd);
                }
                catch (OXException e) {
                    me = e;
                }
                MailFolderSpecialCharsTest.assertTrue((String)"Folder created although an invalid name was specified", (me != null ? 1 : 0) != 0);
                String validName = "Foo&Bar";
                if (inbox.isHoldsFolders()) {
                    fullname = inbox.getFullname() + inbox.getSeparator() + validName;
                    parentFullname = INBOX;
                } else {
                    fullname = validName;
                    parentFullname = "default";
                }
                mfd.setExists(false);
                mfd.setParentFullname(parentFullname);
                mfd.setSeparator(inbox.getSeparator());
                mfd.setSubscribed(false);
                mfd.setName(validName);
                mailAccess.getFolderStorage().createFolder(mfd);
                MailFolderSpecialCharsTest.assertTrue((boolean)mailAccess.getFolderStorage().getFolder(fullname).getName().equals(validName));
                if (fullname != null) {
                    mailAccess.getFolderStorage().deleteFolder(fullname, true);
                }
                validName = "Foo 1 Bar";
                if (inbox.isHoldsFolders()) {
                    fullname = inbox.getFullname() + inbox.getSeparator() + validName;
                    parentFullname = INBOX;
                } else {
                    fullname = validName;
                    parentFullname = "default";
                }
                mfd.setExists(false);
                mfd.setParentFullname(parentFullname);
                mfd.setSeparator(inbox.getSeparator());
                mfd.setSubscribed(false);
                mfd.setName(validName);
                mailAccess.getFolderStorage().createFolder(mfd);
                MailFolderSpecialCharsTest.assertTrue((boolean)mailAccess.getFolderStorage().getFolder(fullname).getName().equals(validName));
                if (fullname != null) {
                    mailAccess.getFolderStorage().deleteFolder(fullname, true);
                }
                validName = "1 und 2";
                if (inbox.isHoldsFolders()) {
                    fullname = inbox.getFullname() + inbox.getSeparator() + validName;
                    parentFullname = INBOX;
                } else {
                    fullname = validName;
                    parentFullname = "default";
                }
                mfd.setExists(false);
                mfd.setParentFullname(parentFullname);
                mfd.setSeparator(inbox.getSeparator());
                mfd.setSubscribed(false);
                mfd.setName(validName);
                mailAccess.getFolderStorage().createFolder(mfd);
                MailFolderSpecialCharsTest.assertTrue((boolean)mailAccess.getFolderStorage().getFolder(fullname).getName().equals(validName));
                if (fullname == null) break block15;
            }
            catch (Throwable throwable) {
                if (fullname != null) {
                    mailAccess.getFolderStorage().deleteFolder(fullname, true);
                }
                mailAccess.close(false);
                throw throwable;
            }
            mailAccess.getFolderStorage().deleteFolder(fullname, true);
        }
        mailAccess.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testFailIfSeparatorContained() throws OXException {
        MailAccess mailAccess;
        block15: {
            SessionObject session = this.getSession();
            mailAccess = MailAccess.getInstance((Session)session);
            mailAccess.connect();
            String fullname = null;
            try {
                String parentFullname = null;
                MailFolder inbox = mailAccess.getFolderStorage().getFolder(INBOX);
                String invalidName = "Foo" + inbox.getSeparator() + "Bar";
                if (inbox.isHoldsFolders()) {
                    fullname = inbox.getFullname() + inbox.getSeparator() + invalidName;
                    parentFullname = INBOX;
                } else {
                    fullname = invalidName;
                    parentFullname = "default";
                }
                MailFolderDescription mfd = new MailFolderDescription();
                mfd.setExists(false);
                mfd.setParentFullname(parentFullname);
                mfd.setSeparator(inbox.getSeparator());
                mfd.setSubscribed(false);
                mfd.setName(invalidName);
                MailPermission p = MailProviderRegistry.getMailProviderBySession((Session)session, (int)0).createNewMailPermission((Session)session, 0);
                p.setEntity(this.getUser());
                p.setAllPermission(128, 128, 128, 128);
                p.setFolderAdmin(true);
                p.setGroupPermission(false);
                mfd.addPermission(p);
                OXException me = null;
                try {
                    mailAccess.getFolderStorage().createFolder(mfd);
                }
                catch (OXException e) {
                    me = e;
                    fullname = null;
                }
                MailFolderSpecialCharsTest.assertTrue((String)"Folder created although an invalid name was specified", (me != null ? 1 : 0) != 0);
                invalidName = inbox.getSeparator() + "Foobar";
                if (inbox.isHoldsFolders()) {
                    fullname = inbox.getFullname() + inbox.getSeparator() + invalidName;
                    parentFullname = INBOX;
                } else {
                    fullname = invalidName;
                    parentFullname = "default";
                }
                mfd.setExists(false);
                mfd.setParentFullname(parentFullname);
                mfd.setSeparator(inbox.getSeparator());
                mfd.setSubscribed(false);
                mfd.setName(invalidName);
                me = null;
                try {
                    mailAccess.getFolderStorage().createFolder(mfd);
                }
                catch (OXException e) {
                    me = e;
                    fullname = null;
                }
                MailFolderSpecialCharsTest.assertTrue((String)"Folder created although an invalid name was specified", (me != null ? 1 : 0) != 0);
                invalidName = "Foobar" + inbox.getSeparator();
                if (inbox.isHoldsFolders()) {
                    fullname = inbox.getFullname() + inbox.getSeparator() + invalidName;
                    parentFullname = INBOX;
                } else {
                    fullname = invalidName;
                    parentFullname = "default";
                }
                mfd.setExists(false);
                mfd.setParentFullname(parentFullname);
                mfd.setSeparator(inbox.getSeparator());
                mfd.setSubscribed(false);
                mfd.setName(invalidName);
                me = null;
                try {
                    mailAccess.getFolderStorage().createFolder(mfd);
                }
                catch (OXException e) {
                    me = e;
                    fullname = null;
                }
                MailFolderSpecialCharsTest.assertTrue((String)"Folder created although an invalid name was specified", (me != null ? 1 : 0) != 0);
                if (fullname == null) break block15;
            }
            catch (Throwable throwable) {
                if (fullname != null) {
                    mailAccess.getFolderStorage().deleteFolder(fullname, true);
                }
                mailAccess.close(false);
                throw throwable;
            }
            mailAccess.getFolderStorage().deleteFolder(fullname, true);
        }
        mailAccess.close(false);
    }
}

