/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.importexport;

import com.openexchange.tools.versit.ICalendar;
import com.openexchange.tools.versit.Parameter;
import com.openexchange.tools.versit.Property;
import com.openexchange.tools.versit.VCard;
import com.openexchange.tools.versit.VersionedObjectDefinition;
import com.openexchange.tools.versit.VersitDefinition;
import com.openexchange.tools.versit.VersitObject;
import com.openexchange.tools.versit.old.VCard21;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import junit.framework.TestCase;

public class VersitParserTest
extends TestCase {
    public List<VersitObject> parseICal(String data) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(data.getBytes());
        LinkedList<VersitObject> ret = new LinkedList<VersitObject>();
        VersionedObjectDefinition def = ICalendar.definition;
        boolean hasMoreObjects = true;
        VersitDefinition.Reader versitReader = def.getReader((InputStream)is, "UTF-8");
        VersitObject rootVersitObject = def.parseBegin(versitReader);
        ret.add(rootVersitObject);
        while (hasMoreObjects) {
            VersitObject versitObject = null;
            versitObject = def.parseChild(versitReader, rootVersitObject);
            if (versitObject == null) {
                hasMoreObjects = false;
                break;
            }
            ret.add(versitObject);
        }
        return ret;
    }

    public List<VersitObject> parseVCard21(String data) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(data.getBytes());
        LinkedList<VersitObject> ret = new LinkedList<VersitObject>();
        VCard21 def = VCard21.definition;
        boolean hasMoreObjects = true;
        VersitDefinition.Reader versitReader = def.getReader((InputStream)is, "UTF-8");
        VersitObject rootVersitObject = def.parseBegin(versitReader);
        ret.add(rootVersitObject);
        while (hasMoreObjects) {
            VersitObject versitObject = null;
            versitObject = def.parseChild(versitReader, rootVersitObject);
            if (versitObject == null) {
                hasMoreObjects = false;
                break;
            }
            ret.add(versitObject);
        }
        return ret;
    }

    public List<VersitObject> parseVCard3(String data) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(data.getBytes());
        LinkedList<VersitObject> ret = new LinkedList<VersitObject>();
        VersionedObjectDefinition def = VCard.definition;
        boolean hasMoreObjects = true;
        VersitDefinition.Reader versitReader = def.getReader((InputStream)is, "UTF-8");
        VersitObject rootVersitObject = def.parseBegin(versitReader);
        ret.add(rootVersitObject);
        while (hasMoreObjects) {
            VersitObject versitObject = null;
            versitObject = def.parseChild(versitReader, rootVersitObject);
            if (versitObject == null) {
                hasMoreObjects = false;
                break;
            }
            ret.add(versitObject);
        }
        return ret;
    }

    public void test7470() throws IOException {
        String ical = "BEGIN:VCALENDAR\nVERSION:2.0\nMETHOD:REQUEST\nBEGIN:VEVENT\nATTENDEE;CN=\"Camil Bartkowiak (cbartkowiak@oxhemail.open-xchange.com)\";RSVP=TRUE:mailto:cbartkowiak@oxhemail.open-xchange.com\nCLASS:PUBLIC\nCREATED:20070521T150327Z\nDTEND:20070523T090000Z\nDTSTAMP:20070521T150327Z\nDTSTART:20070523T083000Z\nSUMMARY;LANGUAGE=de:Simple Appointment with participant\nEND:VEVENT\nEND:VCALENDAR\n";
        this.parseICal("BEGIN:VCALENDAR\nVERSION:2.0\nMETHOD:REQUEST\nBEGIN:VEVENT\nATTENDEE;CN=\"Camil Bartkowiak (cbartkowiak@oxhemail.open-xchange.com)\";RSVP=TRUE:mailto:cbartkowiak@oxhemail.open-xchange.com\nCLASS:PUBLIC\nCREATED:20070521T150327Z\nDTEND:20070523T090000Z\nDTSTAMP:20070521T150327Z\nDTSTART:20070523T083000Z\nSUMMARY;LANGUAGE=de:Simple Appointment with participant\nEND:VEVENT\nEND:VCALENDAR\n");
    }

    public void test7732() throws IOException {
        String ical = "BEGIN:VCALENDAR\nPRODID:-//Microsoft Corporation//Outlook 12.0 MIMEDIR//EN\nVERSION:2.0\nMETHOD:PUBLISH\nBEGIN:VEVENT\nCLASS:PUBLIC\nCREATED:20070531T130514Z\nDESCRIPTION:\\n\nDTEND:20070912T083000Z\nDTSTAMP:20070531T130514Z\nDTSTART:20070912T080000Z\nLAST-MODIFIED:20070531T130514Z\nLOCATION:loc\nPRIORITY:5\nRRULE:FREQ=DAILY;COUNT=10\nSEQUENCE:0\nSUMMARY;LANGUAGE=de:Daily iCal\nTRANSP:OPAQUE\nUID:040000008200E00074C5B7101A82E008000000005059CADA94A3C701000000000000000010000000A1B56CAC71BB0948833B0C11C333ADB0\nEND:VEVENT\nEND:VCALENDAR";
        this.parseICal("BEGIN:VCALENDAR\nPRODID:-//Microsoft Corporation//Outlook 12.0 MIMEDIR//EN\nVERSION:2.0\nMETHOD:PUBLISH\nBEGIN:VEVENT\nCLASS:PUBLIC\nCREATED:20070531T130514Z\nDESCRIPTION:\\n\nDTEND:20070912T083000Z\nDTSTAMP:20070531T130514Z\nDTSTART:20070912T080000Z\nLAST-MODIFIED:20070531T130514Z\nLOCATION:loc\nPRIORITY:5\nRRULE:FREQ=DAILY;COUNT=10\nSEQUENCE:0\nSUMMARY;LANGUAGE=de:Daily iCal\nTRANSP:OPAQUE\nUID:040000008200E00074C5B7101A82E008000000005059CADA94A3C701000000000000000010000000A1B56CAC71BB0948833B0C11C333ADB0\nEND:VEVENT\nEND:VCALENDAR");
    }

    public void test7735() throws IOException {
        String ical = "BEGIN:VCALENDAR\nVERSION:2.0\nPRODID:-//Microsoft Corporation//Outlook 12.0 MIMEDIR//EN\nBEGIN:VEVENT\nDTSTART:20070814T150000Z\nDTEND:20070814T163000Z\nLOCATION:Olpe\nSUMMARY:Komplizierte Intervalle\nDESCRIPTION:Jeden ersten Sonntag im April\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=4\nEND:VEVENT\nEND:VCALENDAR";
        List<VersitObject> list = this.parseICal("BEGIN:VCALENDAR\nVERSION:2.0\nPRODID:-//Microsoft Corporation//Outlook 12.0 MIMEDIR//EN\nBEGIN:VEVENT\nDTSTART:20070814T150000Z\nDTEND:20070814T163000Z\nLOCATION:Olpe\nSUMMARY:Komplizierte Intervalle\nDESCRIPTION:Jeden ersten Sonntag im April\nRRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=4\nEND:VEVENT\nEND:VCALENDAR");
        VersitParserTest.assertEquals((String)"Two elements in list?", (int)list.size(), (int)2);
    }

    public void test8527() throws IOException {
        String ical = "BEGIN:VCALENDAR\nMETHOD:REQUEST\nPRODID:Microsoft CDO for Microsoft Exchange\nVERSION:2.0\nBEGIN:VEVENT\nDTSTAMP:20070719T155206Z\nDTSTART;TZID=\"(GMT) Greenwich Mean Time/Dublin/Edinburgh/London\":20070724T1\n 10000\nSUMMARY:Open-Xchange discussion \nDTEND;TZID=\"(GMT) Greenwich Mean Time/Dublin/Edinburgh/London\":20070724T113\n 000\nPRIORITY:5\nCLASS:\nDESCRIPTION:Added after empty element\\, but still parsed. Yeah!\nCREATED:20070719T154738Z\nLAST-MODIFIED:20070719T155206Z\nSTATUS:CONFIRMED\nTRANSP:OPAQUE\nEND:VEVENT\nEND:VCALENDAR";
        List<VersitObject> list = this.parseICal("BEGIN:VCALENDAR\nMETHOD:REQUEST\nPRODID:Microsoft CDO for Microsoft Exchange\nVERSION:2.0\nBEGIN:VEVENT\nDTSTAMP:20070719T155206Z\nDTSTART;TZID=\"(GMT) Greenwich Mean Time/Dublin/Edinburgh/London\":20070724T1\n 10000\nSUMMARY:Open-Xchange discussion \nDTEND;TZID=\"(GMT) Greenwich Mean Time/Dublin/Edinburgh/London\":20070724T113\n 000\nPRIORITY:5\nCLASS:\nDESCRIPTION:Added after empty element\\, but still parsed. Yeah!\nCREATED:20070719T154738Z\nLAST-MODIFIED:20070719T155206Z\nSTATUS:CONFIRMED\nTRANSP:OPAQUE\nEND:VEVENT\nEND:VCALENDAR");
        VersitObject obj = list.get(1);
        VersitParserTest.assertEquals((String)"Properties after empty are parsed?", (Object)"Added after empty element, but still parsed. Yeah!", (Object)obj.getProperty("DESCRIPTION").getValue());
        VersitParserTest.assertEquals((String)"All properties are parsed?", (int)10, (int)obj.getPropertyCount());
    }

    public void test9765() throws IOException {
        String vcard = "BEGIN:VCARD\nVERSION:2.1\nFN:Hallo Test\nN:Test;Hallo\nEMAIL;INTERNET:test.hallo@open-xchange.com\nGEO:37,386013;-122,082932\nEND:VCARD\n";
        List<VersitObject> list = this.parseVCard21(vcard);
        VersitObject obj = list.get(0);
        ArrayList geo = (ArrayList)obj.getProperty("GEO").getValue();
        VersitParserTest.assertEquals((int)2, (int)geo.size());
        VersitParserTest.assertEquals((Object)37.386013, geo.get(0));
        VersitParserTest.assertEquals((Object)-122.082932, geo.get(1));
    }

    public void test9762() throws IOException {
        String vcard = "BEGIN:VCARD\nVERSION:2.1\nFN:Hallo Test\nN:Test;Hallo\nEMAIL;INTERNET:test.hallo@open-xchange.com\nGEO:-32.33,44.53\nEND:VCARD\n";
        List<VersitObject> list = this.parseVCard21(vcard);
        VersitObject obj = list.get(0);
        ArrayList geo = (ArrayList)obj.getProperty("GEO").getValue();
        VersitParserTest.assertEquals((int)2, (int)geo.size());
        VersitParserTest.assertEquals((Object)-32.33, geo.get(0));
        VersitParserTest.assertEquals((Object)44.53, geo.get(1));
    }

    public void test9763() throws IOException {
        String vcard = "BEGIN:VCARD\nVERSION:2.1\nFN:Hallo Test\nN:Test;Hallo\nEMAIL;INTERNET:test.hallo@open-xchange.com\nTZ:-04:00\nEND:VCARD\n";
        this.parseVCard21(vcard);
    }

    public void test9815() throws IOException {
        String vcard = "BEGIN:VCARD\nVERSION:3.0\nN:Pope;John\nREV:1997-11-15\nURL:http://www.swbyps.restaurant.french/~chezchic.html\nEND:VCARD\n";
        this.parseVCard21(vcard);
    }

    public void test9766() throws IOException, URISyntaxException {
        String vcard = "BEGIN:VCARD\nVERSION:3.0\nN:Pope;John\nPHOTO;VALUE=URL:http://www.open-xchange.com/wiki/images/8/84/Cisco.jpg\nEND:VCARD\n";
        List<VersitObject> list = this.parseVCard3(vcard);
        VersitObject obj = list.get(0);
        URI imageUrl = (URI)obj.getProperty("PHOTO").getValue();
        VersitParserTest.assertEquals((Object)new URI("http://www.open-xchange.com/wiki/images/8/84/Cisco.jpg"), (Object)imageUrl);
    }

    public void testBug9771() throws IOException {
        String vcard = "BEGIN:VCARD\nVERSION:3.0\nN:Pope;John\nTEL;TYPE=home;TYPE=cell:123435235\nEND:VCARD\n";
        List<VersitObject> list = this.parseVCard3(vcard);
        VersitObject obj = list.get(0);
        Property property = obj.getProperty("TEL");
        Parameter parameter = property.getParameter(0);
        VersitParserTest.assertEquals((int)2, (int)parameter.getValueCount());
        HashSet<String> expected = new HashSet<String>();
        expected.add("home");
        expected.add("cell");
        for (int i = 0; i < 2; ++i) {
            String value = parameter.getValue(i).getText();
            VersitParserTest.assertTrue((String)value.toString(), (boolean)expected.remove(value));
        }
        VersitParserTest.assertTrue((boolean)expected.isEmpty());
    }
}

