/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.importexport;

import com.openexchange.calendar.CalendarSql;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.importexport.AbstractICalImportTest;
import com.openexchange.groupware.importexport.ImportResult;
import com.openexchange.importexport.formats.Format;
import com.openexchange.session.Session;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;

public class Bug8653
extends AbstractICalImportTest {
    public static Test suite() {
        return new JUnit4TestAdapter(Bug8653.class);
    }

    @org.junit.Test
    public void testImportIntoCorrectFolder() throws OXException, UnsupportedEncodingException, SQLException, OXException, OXException, OXException, OXException {
        String ical = "BEGIN:VCALENDAR\nBEGIN:VEVENT\nUID:irgendeinschrott\nSUMMARY:testtermin-\u00dcberschrift\nDESCRIPTION:Bla\nLOCATION:Besprechungszimmer\nCATEGORIES:ImportTerminGroupwise\nSTATUS:CONFIRMED\nDTSTART;VALUE=DATE;TZID=/Mozilla.org/BasicTimezones/GMT:20070830\nDTEND;VALUE=DATE;TZID=/Mozilla.org/BasicTimezones/GMT:20070831\nDTSTAMP:20070731T110038Z\nEND:VEVENT\nEND:VCALENDAR";
        Context ctx = ContextStorage.getInstance().getContext(ContextStorage.getInstance().getContextId("defaultcontext"));
        ImportResult res = this.performOneEntryCheck("BEGIN:VCALENDAR\nBEGIN:VEVENT\nUID:irgendeinschrott\nSUMMARY:testtermin-\u00dcberschrift\nDESCRIPTION:Bla\nLOCATION:Besprechungszimmer\nCATEGORIES:ImportTerminGroupwise\nSTATUS:CONFIRMED\nDTSTART;VALUE=DATE;TZID=/Mozilla.org/BasicTimezones/GMT:20070830\nDTEND;VALUE=DATE;TZID=/Mozilla.org/BasicTimezones/GMT:20070831\nDTSTAMP:20070731T110038Z\nEND:VEVENT\nEND:VCALENDAR", Format.ICAL, 2, "8475", ctx, false);
        CalendarSql appointmentSql = new CalendarSql((Session)sessObj);
        int oid = Integer.valueOf(res.getObjectId());
        CalendarDataObject appointmentObj = appointmentSql.getObjectById(oid, folderId);
        Assert.assertEquals((String)"Title is correct?", (Object)"testtermin-\u00dcberschrift", (Object)appointmentObj.getTitle());
    }

    @org.junit.Test
    public void testImportIntoWrongFolder() throws OXException, UnsupportedEncodingException, SQLException, OXException, OXException, OXException, OXException {
        String ical = "BEGIN:VCALENDAR\nBEGIN:VEVENT\nUID:irgendeinschrott\nSUMMARY:testtermin-\u00dcberschrift\nDESCRIPTION:Bla\nLOCATION:Besprechungszimmer\nCATEGORIES:ImportTerminGroupwise\nSTATUS:CONFIRMED\nDTSTART;VALUE=DATE;TZID=/Mozilla.org/BasicTimezones/GMT:20070830\nDTEND;VALUE=DATE;TZID=/Mozilla.org/BasicTimezones/GMT:20070831\nDTSTAMP:20070731T110038Z\nEND:VEVENT\nEND:VCALENDAR";
        Context ctx = ContextStorage.getInstance().getContext(ContextStorage.getInstance().getContextId("defaultcontext"));
        this.performMultipleEntryImport("BEGIN:VCALENDAR\nBEGIN:VEVENT\nUID:irgendeinschrott\nSUMMARY:testtermin-\u00dcberschrift\nDESCRIPTION:Bla\nLOCATION:Besprechungszimmer\nCATEGORIES:ImportTerminGroupwise\nSTATUS:CONFIRMED\nDTSTART;VALUE=DATE;TZID=/Mozilla.org/BasicTimezones/GMT:20070830\nDTEND;VALUE=DATE;TZID=/Mozilla.org/BasicTimezones/GMT:20070831\nDTSTAMP:20070731T110038Z\nEND:VEVENT\nEND:VCALENDAR", Format.ICAL, 1, "8475", ctx, new Boolean[0]);
    }
}

