/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.calendar.calendarsqltests;

import com.openexchange.calendar.CalendarAdministration;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.calendar.calendarsqltests.CalendarSqlTest;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.delete.DeleteEvent;
import com.openexchange.server.impl.DBPool;
import java.sql.Connection;

public class Bug13358Test
extends CalendarSqlTest {
    public void testDeleteUserGroup() throws Throwable {
        CalendarDataObject appointment = this.appointments.buildAppointmentWithGroupParticipants(this.group);
        appointment.setTitle("Bug 13358 Test");
        this.appointments.save(appointment);
        int objectId = appointment.getObjectID();
        this.clean.add(appointment);
        DeleteEvent deleteEvent = new DeleteEvent((Object)this, this.groupId, 2, this.ctx);
        Connection readcon = DBPool.pickup((Context)this.ctx);
        Connection writecon = DBPool.pickupWriteable((Context)this.ctx);
        CalendarAdministration ca = new CalendarAdministration();
        ca.deletePerformed(deleteEvent, readcon, writecon);
        CalendarDataObject loadApp = this.appointments.load(objectId, this.folders.getStandardFolder(this.userId, this.ctx));
        Participant[] participants = loadApp.getParticipants();
        boolean foundGroup = false;
        boolean foundMember = false;
        for (Participant participant : participants) {
            if (participant.getType() == 2) {
                foundGroup = true;
                continue;
            }
            if (participant.getIdentifier() != this.secondUserId) continue;
            foundMember = true;
        }
        Bug13358Test.assertFalse((String)("Group should not be in the participants: " + Bug13358Test.toString(participants)), (boolean)foundGroup);
        Bug13358Test.assertTrue((String)"Member should be in the participants.", (boolean)foundMember);
    }

    private static String toString(Participant[] participants) {
        StringBuilder sb = new StringBuilder();
        for (Participant participant : participants) {
            sb.append(participant.toString());
            sb.append(':');
            sb.append(participant.getIdentifier());
            sb.append(',');
            sb.append(participant.getType());
            sb.append(';');
        }
        return sb.toString();
    }
}

