/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.calendar.calendarsqltests;

import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.calendar.calendarsqltests.CalendarSqlTest;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;

public class Bug11210Test
extends CalendarSqlTest {
    private CalendarDataObject single;
    private CalendarDataObject single2;
    private CalendarDataObject single3;
    private CalendarDataObject sequenceMonthly;
    private final List<CalendarDataObject> allAppointments = new ArrayList<CalendarDataObject>();
    private int THIS_YEAR;
    private int THIS_MONTH;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.THIS_YEAR = Calendar.getInstance().get(1);
        this.THIS_MONTH = Calendar.getInstance().get(2);
        this.sequenceMonthly = this.appointments.buildBasicAppointment(this.createDate(this.THIS_YEAR, this.THIS_MONTH + 1, 1, 12), this.createDate(this.THIS_YEAR, this.THIS_MONTH + 1, 1, 13));
        this.sequenceMonthly.setRecurrenceType(3);
        this.sequenceMonthly.setInterval(1);
        this.sequenceMonthly.setDayInMonth(1);
        this.single = this.appointments.buildBasicAppointment(this.createDate(this.THIS_YEAR, this.THIS_MONTH + 2, 1, 12), this.createDate(this.THIS_YEAR, this.THIS_MONTH + 2, 1, 13));
        this.single2 = this.appointments.buildBasicAppointment(this.createDate(this.THIS_YEAR, this.THIS_MONTH + 3, 1, 12), this.createDate(this.THIS_YEAR, this.THIS_MONTH + 3, 1, 13));
        this.single3 = this.appointments.buildBasicAppointment(this.createDate(this.THIS_YEAR + 2, this.THIS_MONTH, 1, 12), this.createDate(this.THIS_YEAR + 2, this.THIS_MONTH, 1, 13));
        this.allAppointments.add(this.single);
        this.allAppointments.add(this.single2);
        this.allAppointments.add(this.sequenceMonthly);
        this.clean.addAll(this.allAppointments);
        this.setIgnoreConflicts(false);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testConflict() throws Exception {
        this.appointments.save(this.single);
        CalendarDataObject[] conflicts = this.appointments.save(this.sequenceMonthly);
        Bug11210Test.assertFalse((String)"No conflict", (conflicts == null ? 1 : 0) != 0);
        Bug11210Test.assertEquals((String)"Number of conflicts not correct", (int)1, (int)conflicts.length);
        Bug11210Test.assertEquals((String)"Wrong conflict", (int)this.single.getObjectID(), (int)conflicts[0].getObjectID());
    }

    public void testNoConflictAfterOneYear() throws Exception {
        this.appointments.save(this.single3);
        CalendarDataObject[] conflicts = this.appointments.save(this.sequenceMonthly);
        Bug11210Test.assertTrue((String)"Conflict occurred", (conflicts == null ? 1 : 0) != 0);
    }

    public void testOnlyOneConflict() throws Exception {
        this.appointments.save(this.single);
        this.appointments.save(this.single2);
        CalendarDataObject[] conflicts = this.appointments.save(this.sequenceMonthly);
        Bug11210Test.assertFalse((String)"No conflict", (conflicts == null ? 1 : 0) != 0);
        Bug11210Test.assertEquals((String)"Number of conflicts not correct", (int)1, (int)conflicts.length);
        Bug11210Test.assertEquals((String)"Wrong conflict", (int)this.single.getObjectID(), (int)conflicts[0].getObjectID());
    }

    protected Date createDate(int year, int month, int day, int hour) {
        Calendar calendar = GregorianCalendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, day);
        calendar.set(11, hour);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    private void setIgnoreConflicts(boolean ignoreConflicts) {
        for (CalendarDataObject app : this.allAppointments) {
            if (app == null) continue;
            app.setIgnoreConflicts(ignoreConflicts);
        }
    }
}

