/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.calendar;

import com.openexchange.calendar.api.CalendarCollection;
import com.openexchange.exception.OXException;
import com.openexchange.group.Group;
import com.openexchange.groupware.Init;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.calendar.CalendarListener;
import com.openexchange.groupware.calendar.tools.CommonAppointments;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.session.Session;
import com.openexchange.setuptools.TestConfig;
import com.openexchange.setuptools.TestContextToolkit;
import com.openexchange.setuptools.TestFolderToolkit;
import com.openexchange.tools.events.TestEventAdmin;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.session.ServerSession;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import junit.framework.TestCase;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class AbstractCalendarTest
extends TestCase {
    protected final List<CalendarDataObject> clean = new ArrayList<CalendarDataObject>();
    protected final List<FolderObject> cleanFolders = new ArrayList<FolderObject>();
    protected String participant1;
    protected String participant2;
    protected String participant3;
    protected String resource1;
    protected String resource2;
    protected String resource3;
    protected String group;
    protected String member;
    protected String user;
    protected String secondUser;
    protected String thirdUser;
    protected String fourthUser;
    protected int userId;
    protected int secondUserId;
    protected int thirdUserId;
    protected int fourthUserId;
    protected int groupId;
    protected Context ctx;
    protected CommonAppointments appointments;
    protected TestFolderToolkit folders;
    protected Session session;
    protected Session session2;
    protected Session session3;
    protected Session session4;
    protected static final int[] ACTION_ALL_FIELDS = new int[]{1, 2, 4, 5, 3, 20, 101, 100, 200, 400, 201, 202, 203, 209, 218, 206, 207, 220, 221, 402, 211, 210, 401, 102, 408};

    protected static Date applyTimeZone2Date(long utcTime, TimeZone timeZone) {
        return new Date(utcTime - (long)timeZone.getOffset(utcTime));
    }

    public void setUp() throws Exception {
        Init.startServer();
        TestEventAdmin.getInstance().clearEvents();
        TestConfig config = new TestConfig();
        this.user = config.getUser();
        this.secondUser = config.getSecondUser();
        this.thirdUser = config.getThirdUser();
        this.fourthUser = config.getFourthUser();
        TestContextToolkit tools = new TestContextToolkit();
        String ctxName = config.getContextName();
        this.ctx = null == ctxName || ctxName.trim().length() == 0 ? tools.getDefaultContext() : tools.getContextByName(ctxName);
        this.appointments = new CommonAppointments(this.ctx, this.user);
        this.participant1 = config.getParticipant1();
        this.participant2 = config.getParticipant2();
        this.participant3 = config.getParticipant3();
        this.resource1 = config.getResource1();
        this.resource2 = config.getResource2();
        this.resource3 = config.getResource3();
        this.folders = new TestFolderToolkit();
        this.group = config.getGroup();
        this.groupId = tools.resolveGroup(this.group, this.ctx);
        Group group = tools.loadGroup(this.groupId, this.ctx);
        int memberid = group.getMember()[0];
        this.member = tools.loadUser(memberid, this.ctx).getLoginInfo();
        this.userId = tools.resolveUser(this.user, this.ctx);
        this.secondUserId = tools.resolveUser(this.secondUser, this.ctx);
        this.thirdUserId = tools.resolveUser(this.thirdUser, this.ctx);
        this.fourthUserId = tools.resolveUser(this.fourthUser, this.ctx);
        this.appointments.deleteAll(this.ctx);
        this.session = tools.getSessionForUser(this.user, this.ctx);
        this.session2 = tools.getSessionForUser(this.secondUser, this.ctx);
        this.session3 = tools.getSessionForUser(this.thirdUser, this.ctx);
        this.session4 = tools.getSessionForUser(this.fourthUser, this.ctx);
    }

    public void tearDown() throws Exception {
        this.appointments.removeAll(this.user, this.clean);
        this.folders.removeAll(this.session, this.cleanFolders);
        Init.stopServer();
    }

    protected JSONObject json(Object ... objects) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        for (int i = 0; i < objects.length; ++i) {
            jsonObject.put(objects[i++].toString(), objects[i]);
        }
        return jsonObject;
    }

    protected void assertContains(SearchIterator iter, CalendarDataObject cdao) throws OXException {
        boolean found = false;
        while (iter.hasNext()) {
            CalendarDataObject cdao2 = (CalendarDataObject)iter.next();
            found = found || cdao.getObjectID() == cdao2.getObjectID();
        }
        AbstractCalendarTest.assertTrue((boolean)found);
    }

    protected void assertContains(JSONArray arr, CalendarDataObject cdao) throws JSONException {
        int size = arr.length();
        for (int i = 0; i < size; ++i) {
            JSONArray row = arr.getJSONArray(i);
            if (row.getInt(0) != cdao.getObjectID()) continue;
            return;
        }
        AbstractCalendarTest.fail((String)("Could not find appointment in respone: " + arr));
    }

    protected void assertContainsAsJSONObject(JSONArray arr, CalendarDataObject cdao) throws JSONException {
        int size = arr.length();
        for (int i = 0; i < size; ++i) {
            JSONObject row = arr.getJSONObject(i);
            if (row.getInt("id") != cdao.getObjectID()) continue;
            return;
        }
        AbstractCalendarTest.fail((String)("Could not find appointment in respone: " + arr));
    }

    protected static int convertCalendarDAY_OF_WEEK2CalendarDataObjectDAY_OF_WEEK(int calendarDAY_OF_WEEK) {
        switch (calendarDAY_OF_WEEK) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 8;
            }
            case 5: {
                return 16;
            }
            case 6: {
                return 32;
            }
            case 7: {
                return 64;
            }
        }
        return -1;
    }

    protected List<Appointment> read(SearchIterator<Appointment> si) throws OXException {
        ArrayList<Appointment> appointments = new ArrayList<Appointment>();
        while (si.hasNext()) {
            appointments.add((Appointment)si.next());
        }
        return appointments;
    }

    public AbstractCalendarTest() {
    }

    public AbstractCalendarTest(String name) {
        super(name);
    }

    protected CalendarCollection getTools() {
        return new CalendarCollection();
    }

    public static final class TestCalendarListener
    implements CalendarListener {
        private String called;
        List<Object> args = new ArrayList<Object>();
        private Verifyer verifyer;

        public void createdChangeExceptionInRecurringAppointment(Appointment master, Appointment changeException, int inFolder, ServerSession session) {
            this.called = "createdChangeExceptionInRecurringAppointment";
            this.args.add(master);
            this.args.add(changeException);
            this.args.add(session);
            this.verifyer.verify(this);
        }

        public void clear() {
            this.called = null;
            this.args.clear();
        }

        public String getCalledMethodName() {
            return this.called;
        }

        public List<Object> getArgs() {
            return this.args;
        }

        public boolean wasCalled() {
            return this.called != null;
        }

        public Object getArg(int i) {
            return this.args.get(i);
        }

        public Verifyer getVerifyer() {
            return this.verifyer;
        }

        public void setVerifyer(Verifyer verifyer) {
            this.verifyer = verifyer;
        }
    }

    public static interface Verifyer {
        public void verify(TestCalendarListener var1);
    }
}

