/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.bugs;

import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import java.util.Date;

public class Bug22352Test
extends CalDAVTest {
    public Bug22352Test(String name) {
        super(name);
    }

    public void testLongNumericResourceName() throws Exception {
        String uid = "2010042814505442675";
        String summary = "bug 22352";
        String location = "test";
        Date start = TimeTools.D("tomorrow at 3pm");
        Date end = TimeTools.D("tomorrow at 4pm");
        String iCal = Bug22352Test.generateICal(start, end, uid, summary, location);
        Bug22352Test.assertEquals((String)"response code wrong", (int)201, (int)super.putICal(uid, iCal));
        Appointment appointment = super.getAppointment(uid);
        super.rememberForCleanUp(appointment);
        Bug22352Test.assertEquals(appointment, start, end, uid, summary, location);
        ICalResource iCalResource = super.get(uid, null);
        Bug22352Test.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Bug22352Test.assertEquals((String)"UID wrong", (String)uid, (String)iCalResource.getVEvent().getUID());
        Bug22352Test.assertEquals((String)"SUMMARY wrong", (String)summary, (String)iCalResource.getVEvent().getSummary());
        Bug22352Test.assertEquals((String)"LOCATION wrong", (String)location, (String)iCalResource.getVEvent().getLocation());
    }
}

