/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task;

import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.groupware.modules.Module;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.test.FolderTestManager;
import com.openexchange.test.TaskTestManager;
import java.util.Date;

public abstract class ManagedTaskTest
extends AbstractAJAXSession {
    protected TaskTestManager manager;
    protected int folderID;
    protected Task actual;
    private FolderTestManager fManager;

    public ManagedTaskTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.manager = new TaskTestManager(this.getClient());
        this.fManager = new FolderTestManager(this.getClient());
        this.folderID = this.fManager.insertFolderOnServer(this.fManager.generateFolder("Managed task test folder #" + System.currentTimeMillis(), Module.TASK.getFolderConstant(), this.getClient().getValues().getPrivateTaskFolder(), this.getClient().getValues().getUserId())).getObjectID();
        this.actual = null;
    }

    @Override
    public void tearDown() throws Exception {
        this.manager.cleanUp();
        this.fManager.cleanUp();
        super.tearDown();
    }

    public Task generateTask(String title) {
        Task task = new Task();
        task.setParentFolderID(this.folderID);
        task.setTitle(title);
        task.setStartDate(new Date());
        task.setEndDate(new Date());
        return task;
    }
}

