/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.session;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.session.actions.ChangeIPRequest;
import com.openexchange.ajax.session.actions.ChangeIPResponse;
import com.openexchange.ajax.session.actions.RefreshSecretRequest;
import com.openexchange.ajax.session.actions.RefreshSecretResponse;
import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.sessiond.SessionExceptionCodes;

public final class ChangeIPTest
extends AbstractAJAXSession {
    private AJAXClient client;

    public ChangeIPTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
    }

    @Override
    protected void tearDown() throws Exception {
        this.client = null;
        super.tearDown();
    }

    public void testIPChange() throws Throwable {
        String ipAdress = "192.168.123.321";
        ChangeIPRequest request1 = new ChangeIPRequest(ipAdress, false);
        ChangeIPResponse response1 = this.client.execute(request1);
        ChangeIPTest.assertFalse((String)"Change IP response contains an exception.", (boolean)response1.hasError());
        ChangeIPTest.assertTrue((String)"Change IP response contains wrong data.", (boolean)response1.hasCorrectResponse());
        RefreshSecretRequest request2 = new RefreshSecretRequest(false);
        RefreshSecretResponse response2 = this.client.execute(request2);
        ChangeIPTest.assertTrue((String)"Refresh request should be denied because of wrong IP.", (boolean)response2.hasError());
        OXException e = response2.getException();
        ChangeIPTest.assertEquals((String)"Wrong exception message.", (String)SessionExceptionCodes.WRONG_CLIENT_IP.getPrefix(), (String)e.getPrefix());
        ChangeIPTest.assertEquals((String)"Wrong exception message.", (Object)Category.CATEGORY_PERMISSION_DENIED, (Object)e.getCategory());
        ChangeIPTest.assertEquals((String)"Wrong exception message.", (int)SessionExceptionCodes.WRONG_CLIENT_IP.getNumber(), (int)e.getCode());
    }
}

