/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.roundtrip.pubsub;

import com.openexchange.ajax.publish.tests.PublicationTestManager;
import com.openexchange.ajax.roundtrip.pubsub.OXMFContactLifeCycleTest;
import com.openexchange.ajax.subscribe.test.SubscriptionTestManager;
import com.openexchange.datatypes.genericonf.DynamicFormDescription;
import com.openexchange.datatypes.genericonf.FormElement;
import com.openexchange.groupware.container.Contact;
import com.openexchange.publish.Publication;
import com.openexchange.publish.PublicationTargetDiscoveryService;
import com.openexchange.publish.SimPublicationTargetDiscoveryService;
import com.openexchange.subscribe.Subscription;

public class DoNotLoseContactsWhenPublishingAndSubscribing
extends OXMFContactLifeCycleTest {
    public DoNotLoseContactsWhenPublishingAndSubscribing(String name) {
        super(name);
    }

    public void testShouldNotLoseContactsWhileRoundtripping() throws Exception {
        this.createContact("Herbert", "Meier");
        PublicationTestManager pubMgr = this.getPublishManager();
        SubscriptionTestManager subMgr = this.getSubscribeManager();
        SimPublicationTargetDiscoveryService pubDiscovery = new SimPublicationTargetDiscoveryService();
        pubMgr.setPublicationTargetDiscoveryService((PublicationTargetDiscoveryService)pubDiscovery);
        Publication publication = this.generatePublication("contacts", String.valueOf(this.pubFolder.getObjectID()), pubDiscovery);
        pubMgr.newAction(publication);
        DynamicFormDescription formDescription = publication.getTarget().getFormDescription();
        formDescription.add(FormElement.input((String)"url", (String)"URL"));
        Subscription subscription = this.generateOXMFSubscription(formDescription);
        subscription.setFolderId(this.subFolder.getObjectID());
        subMgr.setFormDescription(formDescription);
        String pubUrl = (String)publication.getConfiguration().get("url");
        subscription.getConfiguration().put("url", pubUrl);
        subMgr.newAction(subscription);
        subMgr.refreshAction(subscription.getId());
        Contact[] contacts = this.cMgr.allAction(this.subFolder.getObjectID());
        DoNotLoseContactsWhenPublishingAndSubscribing.assertEquals((String)"Should only contain one contact after first publication", (int)1, (int)contacts.length);
        this.createContact("Hubert", "Meier");
        Thread.sleep(31000L);
        subMgr.refreshAction(subscription.getId());
        contacts = this.cMgr.allAction(this.subFolder.getObjectID());
        DoNotLoseContactsWhenPublishingAndSubscribing.assertEquals((String)"Should have two contacts after update", (int)2, (int)contacts.length);
    }
}

