/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.publish.tests;

import com.openexchange.ajax.publish.actions.ListPublicationsRequest;
import com.openexchange.ajax.publish.actions.ListPublicationsResponse;
import com.openexchange.ajax.publish.actions.NewPublicationRequest;
import com.openexchange.ajax.publish.actions.NewPublicationResponse;
import com.openexchange.ajax.publish.tests.AbstractPublicationTest;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.java.Autoboxing;
import com.openexchange.publish.Publication;
import com.openexchange.publish.PublicationTargetDiscoveryService;
import com.openexchange.publish.SimPublicationTargetDiscoveryService;
import java.io.IOException;
import java.util.Arrays;
import org.json.JSONArray;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class ListPublicationsTest
extends AbstractPublicationTest {
    public ListPublicationsTest(String name) {
        super(name);
    }

    public void testListExistingPublication() throws OXException, IOException, SAXException, JSONException, OXException, OXException {
        Contact contact = this.createDefaultContactFolderWithOneContact();
        String folderID = String.valueOf(contact.getParentFolderID());
        String module = "contacts";
        SimPublicationTargetDiscoveryService discovery = new SimPublicationTargetDiscoveryService();
        this.pubMgr.setPublicationTargetDiscoveryService((PublicationTargetDiscoveryService)discovery);
        Publication expected = this.generatePublication(module, folderID, discovery);
        expected.setDisplayName("This will be changed");
        NewPublicationRequest newReq = new NewPublicationRequest(expected);
        NewPublicationResponse newResp = this.getClient().execute(newReq);
        ListPublicationsTest.assertFalse((String)"Precondition: Should be able to create a publication", (boolean)newResp.hasError());
        expected.setId(newResp.getId());
        ListPublicationsRequest listReq = new ListPublicationsRequest(Arrays.asList(Autoboxing.I((int)expected.getId())), Arrays.asList("id", "entity", "entityModule", "displayName", "target"));
        ListPublicationsResponse listResp = this.getClient().execute(listReq);
        ListPublicationsTest.assertEquals((String)"Should only find one element", (int)1, (int)listResp.getList().size());
        JSONArray actual = listResp.getList().get(0);
        ListPublicationsTest.assertEquals((String)"Should have same publication ID", (int)expected.getId(), (int)actual.getInt(0));
        ListPublicationsTest.assertEquals((Object)expected.getEntityId(), (Object)actual.getJSONObject(1).get("folder"));
        ListPublicationsTest.assertEquals((String)"Should have same module", (String)expected.getModule(), (String)actual.getString(2));
        ListPublicationsTest.assertFalse((String)"Should change display name", (boolean)expected.getDisplayName().equals(actual.getString(3)));
        ListPublicationsTest.assertEquals((String)"Should have same target ID", (String)expected.getTarget().getId(), (String)actual.getString(4));
    }

    public void testListExistingPublicationOfEmptyFolder() throws OXException, IOException, SAXException, JSONException, OXException, OXException {
        FolderObject contact = this.createDefaultContactFolder();
        String folderID = String.valueOf(contact.getObjectID());
        String module = "contacts";
        SimPublicationTargetDiscoveryService discovery = new SimPublicationTargetDiscoveryService();
        this.pubMgr.setPublicationTargetDiscoveryService((PublicationTargetDiscoveryService)discovery);
        Publication expected = this.generatePublication(module, folderID, discovery);
        expected.setDisplayName("This will be changed");
        this.pubMgr.newAction(expected);
        NewPublicationResponse newResp = (NewPublicationResponse)this.pubMgr.getLastResponse();
        ListPublicationsTest.assertFalse((String)"Precondition: Should be able to create a publication", (boolean)newResp.hasError());
        expected.setId(newResp.getId());
        this.pubMgr.listAction(Arrays.asList(Autoboxing.I((int)expected.getId())), Arrays.asList("id", "entity", "entityModule", "displayName", "target"));
        ListPublicationsResponse listResp = (ListPublicationsResponse)this.pubMgr.getLastResponse();
        ListPublicationsTest.assertEquals((String)"Should only find one element", (int)1, (int)listResp.getList().size());
        JSONArray actual = listResp.getList().get(0);
        ListPublicationsTest.assertEquals((String)"Should have same publication ID", (int)expected.getId(), (int)actual.getInt(0));
        ListPublicationsTest.assertEquals((Object)expected.getEntityId(), (Object)actual.getJSONObject(1).get("folder"));
        ListPublicationsTest.assertEquals((String)"Should have same module", (String)expected.getModule(), (String)actual.getString(2));
        ListPublicationsTest.assertFalse((String)"Should change display name", (boolean)expected.getDisplayName().equals(actual.getString(3)));
        ListPublicationsTest.assertEquals((String)"Should have same target ID", (String)expected.getTarget().getId(), (String)actual.getString(4));
    }
}

