/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail.filter;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXSession;
import com.openexchange.ajax.mail.filter.AbstractMailFilterTest;
import com.openexchange.ajax.mail.filter.Rule;
import com.openexchange.ajax.mail.filter.action.AbstractAction;
import com.openexchange.ajax.mail.filter.action.Keep;
import com.openexchange.ajax.mail.filter.comparison.IsComparison;
import com.openexchange.ajax.mail.filter.test.HeaderTest;
import com.openexchange.ajax.mailaccount.actions.MailAccountGetRequest;
import com.openexchange.ajax.mailaccount.actions.MailAccountGetResponse;
import com.openexchange.mailaccount.MailAccountDescription;

public class AdminListTest
extends AbstractMailFilterTest {
    private AJAXClient userClient;
    private AJAXSession userSession;
    private AJAXClient adminClient;
    private AJAXSession adminSession;
    private Rule rule;

    public AdminListTest(String name) {
        super(name);
    }

    public void testUserHasAccessToOtherUsersRules() throws Exception {
        this.userClient = this.getClient();
        this.userSession = this.userClient.getSession();
        this.adminClient = new AJAXClient(AJAXClient.User.OXAdmin);
        this.adminSession = this.adminClient.getSession();
        this.rule = new Rule();
        this.rule.setName("testUserHasAccessToOtherUsersRules");
        this.rule.setActioncmds(new AbstractAction[]{new Keep()});
        IsComparison isComp = new IsComparison();
        this.rule.setTest(new HeaderTest(isComp, new String[]{"testheader"}, new String[]{"testvalue"}));
        String rid = AdminListTest.insertRule(this.rule, null, this.userSession);
        Rule[] userRules = AdminListTest.listRules(this.userSession);
        MailAccountGetRequest getMailAcc = new MailAccountGetRequest(0, false);
        MailAccountGetResponse response = this.userClient.execute(getMailAcc);
        MailAccountDescription description = response.getAsDescription();
        String userImapLogin = description.getLogin();
        Rule[] adminRules = AdminListTest.listRulesForUser(this.adminSession, userImapLogin);
        for (Rule ur : userRules) {
            boolean foundRule = false;
            for (Rule ar : adminRules) {
                if (!ar.getId().equals(ur.getId())) continue;
                foundRule = true;
                break;
            }
            AdminListTest.assertTrue((String)"Did not find rule.", (boolean)foundRule);
        }
        AdminListTest.deleteRule(rid, null, this.userSession);
        this.adminClient.logout();
    }
}

