/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.mail.actions.AbstractMailRequest;
import com.openexchange.ajax.mail.actions.NewMailResponse;
import java.util.LinkedList;
import org.json.JSONException;
import org.json.JSONObject;

public class NewMailRequest
extends AbstractMailRequest<NewMailResponse> {
    private final String folder;
    private final String rfc822;
    private final int flags;
    private final boolean failOnError;

    public NewMailRequest(String folder, String rfc822, int flags) {
        this(folder, rfc822, flags, true);
    }

    public NewMailRequest(String folder, String rfc822, int flags, boolean failOnError) {
        this.folder = folder;
        this.rfc822 = rfc822;
        this.flags = flags;
        this.failOnError = failOnError;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    @Override
    public Object getBody() {
        return this.rfc822;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        LinkedList<AJAXRequest.Parameter> list = new LinkedList<AJAXRequest.Parameter>();
        list.add(new AJAXRequest.Parameter("action", "new"));
        list.add(new AJAXRequest.Parameter("src", "1"));
        if (this.folder != null) {
            list.add(new AJAXRequest.Parameter("folder", this.folder));
        }
        if (this.flags >= 0) {
            list.add(new AJAXRequest.Parameter("flags", this.flags));
        }
        return list.toArray(new AJAXRequest.Parameter[list.size()]);
    }

    @Override
    public AbstractAJAXParser<NewMailResponse> getParser() {
        return new AbstractAJAXParser<NewMailResponse>(this.failOnError){

            @Override
            protected NewMailResponse createResponse(Response response) throws JSONException {
                NewMailResponse retval = new NewMailResponse(response);
                JSONObject json = (JSONObject)response.getData();
                if (json.has("folder_id")) {
                    retval.setFolder(json.getString("folder_id"));
                }
                if (json.has("id")) {
                    retval.setId(json.getString("id"));
                }
                return retval;
            }
        };
    }
}

