/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail;

import com.meterware.httpunit.WebResponse;
import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.mail.AbstractMailTest;
import com.openexchange.ajax.mail.actions.AttachmentRequest;
import com.openexchange.ajax.mail.actions.DeleteRequest;
import com.openexchange.ajax.mail.actions.GetRequest;
import com.openexchange.ajax.mail.actions.GetResponse;
import com.openexchange.ajax.mail.actions.SendRequest;
import com.openexchange.configuration.AJAXConfig;
import com.openexchange.mail.MailJSONField;
import com.openexchange.mail.MailListField;
import org.json.JSONArray;
import org.json.JSONObject;

public final class AttachmentTest
extends AbstractMailTest {
    public AttachmentTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testGet() throws Throwable {
        String[] folderAndID = null;
        try {
            String mailObject_25kb = this.createSelfAddressed25KBMailObject().toString();
            folderAndID = Executor.execute(this.getSession(), new SendRequest(mailObject_25kb)).getFolderAndID();
            GetResponse response = Executor.execute(this.getSession(), new GetRequest(folderAndID[0], folderAndID[1]));
            JSONObject mailObject = (JSONObject)response.getResponse().getData();
            AttachmentTest.assertTrue((String)("Missing field " + MailJSONField.ATTACHMENTS.getKey()), (mailObject.has(MailJSONField.ATTACHMENTS.getKey()) && !mailObject.isNull(MailJSONField.ATTACHMENTS.getKey()) ? 1 : 0) != 0);
            JSONArray attachmentArray = mailObject.getJSONArray(MailJSONField.ATTACHMENTS.getKey());
            int len = attachmentArray.length();
            AttachmentTest.assertTrue((String)"Missing attachments", (len > 0 ? 1 : 0) != 0);
            String sequenceId = null;
            for (int i = 0; i < len && sequenceId == null; ++i) {
                JSONObject attachmentObject = attachmentArray.getJSONObject(i);
                String contentType = attachmentObject.getString(MailJSONField.CONTENT_TYPE.getKey());
                if (!contentType.regionMatches(true, 0, "text/htm", 0, 8)) continue;
                sequenceId = attachmentObject.getString(MailListField.ID.getKey());
            }
            AttachmentTest.assertTrue((String)"No HTML part found", (sequenceId != null ? 1 : 0) != 0);
            AttachmentRequest attachmentRequest = new AttachmentRequest(folderAndID[0], folderAndID[1], sequenceId);
            attachmentRequest.setSaveToDisk(false);
            attachmentRequest.setFilter(true);
            WebResponse webResponse = Executor.execute4Download(this.getSession(), attachmentRequest, AJAXConfig.getProperty(AJAXConfig.Property.PROTOCOL), AJAXConfig.getProperty(AJAXConfig.Property.HOSTNAME));
            AttachmentTest.assertTrue((String)"Web response does not indicate HTML content", (boolean)webResponse.isHTML());
            if (folderAndID == null) return;
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                AttachmentTest.fail((String)e.getMessage());
                if (folderAndID == null) return;
            }
            catch (Throwable throwable) {
                if (folderAndID == null) throw throwable;
                String[][] foo = new String[][]{folderAndID};
                Executor.execute(this.getSession(), new DeleteRequest(foo, true));
                throw throwable;
            }
            String[][] foo = new String[][]{folderAndID};
            Executor.execute(this.getSession(), new DeleteRequest(foo, true));
            return;
        }
        String[][] foo = new String[][]{folderAndID};
        Executor.execute(this.getSession(), new DeleteRequest(foo, true));
        return;
    }
}

