/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.kata;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.kata.Step;
import com.openexchange.ajax.kata.fixtures.FixtureStepFactory;
import com.openexchange.test.fixtures.FixtureLoader;
import com.openexchange.test.fixtures.ajax.FixtureLoaderFactory;
import java.io.File;
import java.io.FilenameFilter;
import java.util.List;

public abstract class AbstractDirectoryRunner
extends AbstractAJAXSession {
    private final String dirName;
    private final Class aClass;

    public AbstractDirectoryRunner(String name, String dirName, Class aClass) {
        super(name);
        this.dirName = dirName;
        this.aClass = aClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRunKata() throws Exception {
        FixtureLoader loader = this.buildLoader();
        String[] filenames = this.scanDirectory();
        AJAXClient client = this.getClient();
        FixtureStepFactory stepFactory = new FixtureStepFactory(loader);
        for (String filename : filenames) {
            List<Step> steps = stepFactory.loadSteps(this.aClass, filename);
            try {
                for (Step step : steps) {
                    step.perform(client);
                }
            }
            finally {
                for (Step step : steps) {
                    try {
                        step.cleanUp();
                    }
                    catch (Exception x) {
                        x.printStackTrace();
                    }
                }
            }
        }
    }

    private String[] scanDirectory() {
        return new File(this.dirName).list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".kata.yml");
            }
        });
    }

    private FixtureLoader buildLoader() {
        FixtureLoader loader = FixtureLoaderFactory.getLoader(this.getClient(), null);
        loader.appendToLoadPath(this.dirName);
        return loader;
    }
}

