/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.infostore;

import com.openexchange.ajax.request.JSONSimpleRequest;
import junit.framework.TestCase;
import org.json.JSONArray;
import org.json.JSONObject;

public class JSONSimpleRequestTest
extends TestCase {
    public void testGetParameter() throws Exception {
        String json = "{\"param1\" : \"value1\", \"param2\" : \"value2\"}";
        JSONSimpleRequest req = new JSONSimpleRequest(new JSONObject("{\"param1\" : \"value1\", \"param2\" : \"value2\"}"));
        JSONSimpleRequestTest.assertEquals((String)"value1", (String)req.getParameter("param1"));
        JSONSimpleRequestTest.assertEquals((String)"value2", (String)req.getParameter("param2"));
        JSONSimpleRequestTest.assertNull((Object)req.getParameter("param3"));
    }

    public void testGetParameterValues() throws Exception {
        String json = "{\"param\" : \"value1,value2,value3,value4\"}";
        JSONSimpleRequest req = new JSONSimpleRequest(new JSONObject("{\"param\" : \"value1,value2,value3,value4\"}"));
        String[] values = req.getParameterValues("param");
        JSONSimpleRequestTest.assertEquals((int)4, (int)values.length);
        JSONSimpleRequestTest.assertEquals((String)"value1", (String)values[0]);
        JSONSimpleRequestTest.assertEquals((String)"value2", (String)values[1]);
        JSONSimpleRequestTest.assertEquals((String)"value3", (String)values[2]);
        JSONSimpleRequestTest.assertEquals((String)"value4", (String)values[3]);
    }

    public void testGetBody() throws Exception {
        String json = "{\"data\" : [1,2,3,4] }";
        JSONSimpleRequest req = new JSONSimpleRequest(new JSONObject("{\"data\" : [1,2,3,4] }"));
        JSONArray array = (JSONArray)req.getBody();
        JSONSimpleRequestTest.assertEquals((int)4, (int)array.length());
        for (int i = 1; i < 5; ++i) {
            JSONSimpleRequestTest.assertEquals((int)i, (int)array.getInt(i - 1));
        }
    }
}

