/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.index;

import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.index.actions.GeneralIndexRequest;
import com.openexchange.ajax.index.actions.GeneralIndexResponse;
import com.openexchange.ajax.index.actions.SpotlightRequest;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONValue;
import org.junit.Test;

public class SpotlightTest
extends AbstractAJAXSession {
    public SpotlightTest(String name) {
        super(name);
    }

    @Test
    public void testSpotlight() throws Exception {
        SpotlightRequest req = new SpotlightRequest("ubun*", 10, 10);
        GeneralIndexResponse resp = this.getClient().execute(req);
        JSONValue json = resp.getJSON();
        System.out.println("Spotligh Results:");
        System.out.println(json.toString(2, 0));
        System.out.println("==============");
        System.out.println();
        String[] searchTerms = new String[2];
        JSONObject object = json.toObject();
        JSONArray persons = object.getJSONArray("persons");
        searchTerms[0] = (String)persons.getJSONObject(0).get("value");
        JSONArray topics = object.getJSONArray("topics");
        searchTerms[1] = (String)topics.getJSONObject(0).get("value");
        AJAXRequest.Parameter[] parameters = new AJAXRequest.Parameter[]{new AJAXRequest.Parameter("action", "persons"), new AJAXRequest.Parameter("searchTerm", searchTerms[0])};
        GeneralIndexRequest searchReq = new GeneralIndexRequest(parameters);
        resp = this.getClient().execute(searchReq);
        json = resp.getJSON();
        System.out.println("Persons Search Results (" + searchTerms[0] + "):");
        System.out.println(json.toString(2, 0));
        System.out.println("==============");
        System.out.println();
        parameters = new AJAXRequest.Parameter[]{new AJAXRequest.Parameter("action", "topics"), new AJAXRequest.Parameter("searchTerm", searchTerms[1])};
        searchReq = new GeneralIndexRequest(parameters);
        resp = this.getClient().execute(searchReq);
        json = resp.getJSON();
        System.out.println("Topics Search Results (" + searchTerms[1] + "):");
        System.out.println(json.toString(2, 0));
    }
}

