/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.importexport;

import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.importexport.actions.ICalImportRequest;
import com.openexchange.ajax.importexport.actions.ICalImportResponse;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.importexport.ImportResult;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public final class Bug20738Test
extends AbstractAJAXSession {
    private final List<DeleteRequest> toDelete = new ArrayList<DeleteRequest>();
    private static final String ICAL = "BEGIN:VCALENDAR\r\nPRODID:-//Google Inc//Google Calendar 70.9054//EN\r\nVERSION:2.0\r\nCALSCALE:GREGORIAN\r\nMETHOD:PUBLISH\r\nX-WR-CALNAME:Privat\r\nX-WR-TIMEZONE:Europe/Berlin\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nX-LIC-LOCATION:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:CEST\r\nDTSTART:19700329T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19701025T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VTIMEZONE\r\nTZID:Africa/Ceuta\r\nX-LIC-LOCATION:Africa/Ceuta\r\nBEGIN:DAYLIGHT\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nTZNAME:CEST\r\nDTSTART:19700329T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nTZNAME:CET\r\nDTSTART:19701025T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nDTSTART;TZID=Europe/Berlin:20110727T170000\r\nDTEND;TZID=Europe/Berlin:20110727T180000\r\nDTSTAMP:20110717T154458Z\r\nUID:63D1882A85A5496795DCE32F04EF5F8E00000000000000000000000000000000\r\nATTENDEE;CUTYPE=INDIVIDUAL;ROLE=REQ-PARTICIPANT;PARTSTAT=NEEDS-ACTION;X-NUM\r\n -GUESTS=0:mailto:otto.horst@erdbeerkaese.invalid\r\nRECURRENCE-ID;TZID=Europe/Berlin:20110728T180000\r\nCREATED:20110531T052752Z\r\nDESCRIPTION:\r\nLAST-MODIFIED:20110713T155545Z\r\nLOCATION:C\u00e4cilienstr. 44\r\nSEQUENCE:2\r\nSTATUS:CONFIRMED\r\nSUMMARY:Frau Otto\r\nTRANSP:OPAQUE\r\nCATEGORIES:http://schemas.google.com/g/2005#event\r\nEND:VEVENT\r\nBEGIN:VEVENT\r\nDTSTART;TZID=Europe/Berlin:20110707T150000\r\nDTEND;TZID=Europe/Berlin:20110707T160000\r\nDTSTAMP:20110717T154458Z\r\nUID:63D1882A85A5496795DCE32F04EF5F8E00000000000000000000000000000000\r\nATTENDEE;CUTYPE=INDIVIDUAL;ROLE=REQ-PARTICIPANT;PARTSTAT=NEEDS-ACTION;X-NUM\r\n -GUESTS=0:mailto:otto.horst@erdbeerkaese.invalid\r\nRECURRENCE-ID;TZID=Europe/Berlin:20110707T180000\r\nCREATED:20110531T052752Z\r\nDESCRIPTION:\r\nLAST-MODIFIED:20110713T155545Z\r\nLOCATION:C\u00e4cilienstr. 44\r\nSEQUENCE:2\r\nSTATUS:CONFIRMED\r\nSUMMARY:Frau Otto\r\nTRANSP:OPAQUE\r\nCATEGORIES:http://schemas.google.com/g/2005#event\r\nEND:VEVENT\r\nBEGIN:VEVENT\r\nDTSTART;TZID=Africa/Ceuta:20110616T180000\r\nDTEND;TZID=Africa/Ceuta:20110616T190000\r\nRRULE:FREQ=WEEKLY;BYDAY=TH\r\nEXDATE;TZID=Africa/Ceuta:20110721T180000\r\nEXDATE;TZID=Africa/Ceuta:20110714T180000\r\nDTSTAMP:20110717T154458Z\r\nUID:63D1882A85A5496795DCE32F04EF5F8E00000000000000000000000000000000\r\nATTENDEE;CUTYPE=INDIVIDUAL;ROLE=REQ-PARTICIPANT;PARTSTAT=NEEDS-ACTION;X-NUM\r\n -GUESTS=0:mailto:otto.horst@erdbeerkaese.invalid\r\nCREATED:20110531T052752Z\r\nDESCRIPTION:\r\nLAST-MODIFIED:20110713T155545Z\r\nLOCATION:C\u00e4cilienstr. 44\r\nSEQUENCE:1\r\nSTATUS:CONFIRMED\r\nSUMMARY:Frau Otto\r\nTRANSP:OPAQUE\r\nCATEGORIES:http://schemas.google.com/g/2005#event\r\nEND:VEVENT\r\nEND:VCALENDAR\r\n";

    public Bug20738Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        for (DeleteRequest deleteRequest : this.toDelete) {
            super.getClient().execute(deleteRequest);
        }
        super.tearDown();
    }

    public void testNoRecurrenceMasterFound() throws Throwable {
        ImportResult[] firstResults;
        AJAXClient client = super.getClient();
        int folderId = client.getValues().getPrivateAppointmentFolder();
        ICalImportRequest firstRequest = new ICalImportRequest(folderId, ICAL, false);
        ICalImportResponse firstResponse = Executor.execute(client, firstRequest);
        for (ImportResult result : firstResults = firstResponse.getImports()) {
            Bug20738Test.assertFalse((String)"Initial import already failed", (boolean)result.hasError());
            this.markForCleanup(result);
        }
        ICalImportRequest secondRequest = new ICalImportRequest(folderId, ICAL, false);
        ICalImportResponse secondResponse = Executor.execute(client, secondRequest);
        ImportResult[] secondResults = secondResponse.getImports();
        int app0100Count = 0;
        int ica0020Count = 0;
        for (ImportResult result : secondResults) {
            Bug20738Test.assertTrue((String)"Second import passed without error", (boolean)result.hasError());
            OXException exception = result.getException();
            Bug20738Test.assertNotNull((String)"Got no conversion exception", (Object)((Object)exception));
            if ("ICA-0020".equals(exception.getErrorCode())) {
                ++ica0020Count;
                continue;
            }
            if ("APP-0100".equals(exception.getErrorCode())) {
                ++app0100Count;
                continue;
            }
            Bug20738Test.fail((String)("Unexpected conversion exception: " + exception.getErrorCode()));
        }
        Bug20738Test.assertEquals((String)"Incorrect number of ICA-0020 warnings", (int)2, (int)ica0020Count);
        Bug20738Test.assertEquals((String)"Incorrect number of APP-0100 warnings", (int)1, (int)app0100Count);
    }

    private void markForCleanup(ImportResult result) {
        DeleteRequest deleteRequest = new DeleteRequest(Integer.parseInt(result.getObjectId()), Integer.parseInt(result.getFolder()), new Date(Long.MAX_VALUE));
        deleteRequest.setFailOnError(false);
        this.toDelete.add(deleteRequest);
    }
}

