/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.framework;

import com.openexchange.ajax.framework.AJAXRequest;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class Params {
    private final List<AJAXRequest.Parameter> parameters = new LinkedList<AJAXRequest.Parameter>();

    public Params() {
    }

    public Params(String key, String value) {
        this();
        this.add(key, value);
    }

    public Params(String ... items) {
        this();
        this.add(items);
    }

    public Params(AJAXRequest.Parameter ... params) {
        this();
        this.add(params);
    }

    public void add(String key, String value) {
        this.parameters.add(new AJAXRequest.Parameter(key, value));
    }

    public void add(AJAXRequest.Parameter param) {
        this.parameters.add(param);
    }

    public void add(AJAXRequest.Parameter ... params) {
        this.parameters.addAll(Arrays.asList(params));
    }

    public void add(Params params) {
        this.add(params.toArray());
    }

    public void add(String ... items) {
        if (items.length % 2 == 1) {
            throw new IllegalArgumentException("The number of arguments should be even: key, value, key, value...");
        }
        for (int i = 0; i < items.length; ++i) {
            if (i % 2 != 1) continue;
            this.parameters.add(new AJAXRequest.Parameter(items[i - 1], items[i]));
        }
    }

    public AJAXRequest.Parameter[] toArray() {
        return this.parameters.toArray(new AJAXRequest.Parameter[0]);
    }

    public List<AJAXRequest.Parameter> toList() {
        return this.parameters;
    }

    public String toString() {
        StringBuffer buffy = new StringBuffer();
        for (AJAXRequest.Parameter p : this.parameters) {
            buffy.append('&').append(p.toString());
        }
        buffy.replace(0, 1, "?");
        return buffy.toString();
    }
}

