/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.attach.actions;

import com.openexchange.ajax.attach.AttachmentTools;
import com.openexchange.ajax.attach.actions.AbstractAttachmentRequest;
import com.openexchange.ajax.attach.actions.AttachParser;
import com.openexchange.ajax.attach.actions.AttachResponse;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.groupware.attach.AttachmentField;
import com.openexchange.groupware.container.CommonObject;
import java.io.InputStream;
import org.json.JSONException;
import org.json.JSONObject;

public class AttachRequest
extends AbstractAttachmentRequest<AttachResponse> {
    private final int moduleId;
    private final int folderId;
    private final int attachedId;
    private final String fileName;
    private final InputStream data;
    private final String mimeType;

    public AttachRequest(CommonObject obj, String fileName, InputStream data, String mimeType) {
        this.moduleId = AttachmentTools.determineModule(obj);
        this.folderId = obj.getParentFolderID();
        this.attachedId = obj.getObjectID();
        this.fileName = fileName;
        this.data = data;
        this.mimeType = mimeType;
    }

    @Override
    public Object getBody() {
        return null;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.UPLOAD;
    }

    private String writeJSON() throws JSONException {
        JSONObject json = new JSONObject();
        json.put(AttachmentField.MODULE_ID_LITERAL.getName(), this.moduleId);
        json.put(AttachmentField.FOLDER_ID_LITERAL.getName(), this.folderId);
        json.put(AttachmentField.ATTACHED_ID_LITERAL.getName(), this.attachedId);
        return json.toString();
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() throws JSONException {
        return new AJAXRequest.Parameter[]{new AJAXRequest.URLParameter("action", "attach"), new AJAXRequest.FieldParameter("json_0", this.writeJSON()), new AJAXRequest.FileParameter("file_0", this.fileName, this.data, this.mimeType)};
    }

    public AttachParser getParser() {
        return new AttachParser(true);
    }
}

