/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.attach;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.openexchange.ajax.AttachmentTest;
import com.openexchange.ajax.LoginTest;
import com.openexchange.ajax.container.Response;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.AttachmentMetadata;
import com.openexchange.groupware.attach.impl.AttachmentImpl;
import com.openexchange.test.OXTestToolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xml.sax.SAXException;

public abstract class AbstractAttachmentTest
extends AttachmentTest {
    protected int attachedId = -1;
    protected int folderId = -1;
    protected int moduleId = -1;
    protected String sessionId;

    public AbstractAttachmentTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.sessionId = this.getSessionId();
        this.folderId = this.getExclusiveWritableFolder(this.sessionId);
        this.attachedId = this.createExclusiveWritableAttachable(this.sessionId, this.folderId);
        this.moduleId = this.getModule();
    }

    @Override
    public void tearDown() throws Exception {
        this.removeAttachments();
        this.removeAttachable(this.folderId, this.attachedId, this.sessionId);
        super.tearDown();
    }

    public abstract int createExclusiveWritableAttachable(String var1, int var2) throws Exception;

    public abstract int getExclusiveWritableFolder(String var1) throws Exception;

    public abstract void removeAttachable(int var1, int var2, String var3) throws Exception;

    public abstract int getModule() throws Exception;

    protected void doDetach() throws Exception {
        this.doGet();
        int id = ((AttachmentMetadata)this.clean.get(0)).getId();
        this.removeAttachments();
        Response res = this.get(this.getWebConversation(), this.sessionId, this.folderId, this.attachedId, this.moduleId, id);
        AbstractAttachmentTest.assertTrue((boolean)res.hasError());
    }

    protected void doUpdates() throws Exception {
        int i;
        int i2;
        this.upload();
        Thread.sleep(2000L);
        Response res = this.get(this.getWebConversation(), this.sessionId, this.folderId, this.attachedId, this.moduleId, ((AttachmentMetadata)this.clean.get(0)).getId());
        AbstractAttachmentTest.assertNoError(res);
        long timestamp = res.getTimestamp().getTime();
        this.upload();
        this.upload();
        this.upload();
        this.upload();
        ArrayList createdLater = new ArrayList(this.clean.subList(1, this.clean.size()));
        res = this.updates(this.getWebConversation(), this.sessionId, this.folderId, this.attachedId, this.moduleId, timestamp, new int[]{1, 803}, 4, "ASC");
        AbstractAttachmentTest.assertNoError(res);
        JSONArray arrayOfArrays = (JSONArray)res.getData();
        int updates = 0;
        for (i2 = 0; i2 < arrayOfArrays.length(); ++i2) {
            if (!(arrayOfArrays.get(i2) instanceof JSONArray)) continue;
            ++updates;
        }
        AbstractAttachmentTest.assertEquals((String)(arrayOfArrays.toString() + " were modified later than " + timestamp), (int)createdLater.size(), (int)updates);
        for (i2 = 0; i2 < arrayOfArrays.length(); ++i2) {
            Object tmp = arrayOfArrays.get(i2);
            if (!(tmp instanceof JSONArray)) continue;
            JSONArray values = (JSONArray)tmp;
            AttachmentMetadata attachment = (AttachmentMetadata)createdLater.get(i2);
            AbstractAttachmentTest.assertEquals((int)values.getInt(0), (int)attachment.getId());
            AbstractAttachmentTest.assertEquals((String)this.testFile.getName(), (String)values.getString(1));
        }
        ArrayList copy = new ArrayList(this.clean);
        this.removeAttachments();
        res = this.updates(this.getWebConversation(), this.sessionId, this.folderId, this.attachedId, this.moduleId, timestamp, new int[]{1, 803}, 4, "ASC");
        JSONArray arrayOfIds = (JSONArray)res.getData();
        updates = 0;
        for (i = 0; i < arrayOfIds.length(); ++i) {
            if (!(arrayOfIds.get(i) instanceof Integer)) continue;
            ++updates;
        }
        AbstractAttachmentTest.assertEquals((String)arrayOfIds.toString(), (int)copy.size(), (int)updates);
        for (i = 0; i < arrayOfIds.length(); ++i) {
            Object tmp = arrayOfIds.get(i);
            if (!(tmp instanceof Integer)) continue;
            int id = (Integer)tmp;
            AttachmentMetadata attachment = (AttachmentMetadata)copy.get(i);
            AbstractAttachmentTest.assertEquals((int)id, (int)attachment.getId());
        }
    }

    protected void doAll() throws Exception {
        int i;
        this.upload();
        this.upload();
        this.upload();
        this.upload();
        this.upload();
        Response res = this.all(this.getWebConversation(), this.sessionId, this.folderId, this.attachedId, this.moduleId, new int[]{1, 803}, 4, "ASC");
        AbstractAttachmentTest.assertNoError(res);
        JSONArray arrayOfArrays = (JSONArray)res.getData();
        int updates = 0;
        for (i = 0; i < arrayOfArrays.length(); ++i) {
            if (!(arrayOfArrays.get(i) instanceof JSONArray)) continue;
            ++updates;
        }
        AbstractAttachmentTest.assertTrue((String)arrayOfArrays.toString(), (this.clean.size() <= updates ? 1 : 0) != 0);
        for (i = 0; i < this.clean.size(); ++i) {
            AttachmentMetadata attachment = (AttachmentMetadata)this.clean.get(i);
            JSONArray found = null;
            for (int j = 0; null == found && j < arrayOfArrays.length(); ++j) {
                JSONArray values;
                Object tmp = arrayOfArrays.get(j);
                if (!(tmp instanceof JSONArray) || (values = (JSONArray)tmp).getInt(0) != attachment.getId()) continue;
                found = values;
            }
            AbstractAttachmentTest.assertTrue((null != found ? 1 : 0) != 0);
            AbstractAttachmentTest.assertEquals((String)this.testFile.getName(), (String)found.getString(1));
        }
    }

    protected void doList() throws Exception {
        this.upload();
        this.upload();
        this.upload();
        this.upload();
        this.upload();
        int[] ids = new int[]{((AttachmentMetadata)this.clean.get(0)).getId(), ((AttachmentMetadata)this.clean.get(2)).getId(), ((AttachmentMetadata)this.clean.get(4)).getId()};
        Response res = this.list(this.getWebConversation(), this.sessionId, this.folderId, this.attachedId, this.moduleId, ids, new int[]{1, 803});
        AbstractAttachmentTest.assertNoError(res);
        JSONArray arrayOfArrays = (JSONArray)res.getData();
        AbstractAttachmentTest.assertEquals((int)ids.length, (int)arrayOfArrays.length());
        for (int i = 0; i < arrayOfArrays.length(); ++i) {
            JSONArray values = arrayOfArrays.getJSONArray(i);
            AbstractAttachmentTest.assertEquals((int)ids[i], (int)values.getInt(0));
            AbstractAttachmentTest.assertEquals((String)this.testFile.getName(), (String)values.getString(1));
        }
    }

    protected void doGet() throws Exception {
        this.upload();
        Response res = this.get(this.getWebConversation(), this.sessionId, this.folderId, this.attachedId, this.moduleId, ((AttachmentMetadata)this.clean.get(0)).getId());
        AbstractAttachmentTest.assertNoError(res);
        JSONObject data = (JSONObject)res.getData();
        AbstractAttachmentTest.assertEquals((int)this.folderId, (int)data.getInt("folder"));
        AbstractAttachmentTest.assertEquals((int)this.attachedId, (int)data.getInt("attached"));
        AbstractAttachmentTest.assertEquals((int)this.moduleId, (int)data.getInt("module"));
        AbstractAttachmentTest.assertEquals((String)this.testFile.getName(), (String)data.getString("filename"));
        AbstractAttachmentTest.assertEquals((String)"text/plain", (String)data.getString("file_mimetype"));
        AbstractAttachmentTest.assertEquals((long)this.testFile.length(), (long)data.getLong("file_size"));
        AbstractAttachmentTest.assertEquals((int)((AttachmentMetadata)this.clean.get(0)).getId(), (int)data.getInt("id"));
    }

    protected void doMultiple() throws Exception {
        AttachmentImpl attachment = new AttachmentImpl();
        AttachmentImpl attachment2 = new AttachmentImpl();
        attachment.setFolderId(this.folderId);
        attachment.setAttachedId(this.attachedId);
        attachment.setModuleId(this.moduleId);
        attachment2.setFolderId(this.folderId);
        attachment2.setAttachedId(this.attachedId);
        attachment2.setModuleId(this.moduleId);
        Response res = this.attach(this.getWebConversation(), this.sessionId, this.folderId, this.attachedId, this.moduleId, Arrays.asList(this.testFile, this.testFile2));
        AbstractAttachmentTest.assertNoError(res);
        attachment.setId(((JSONArray)res.getData()).getInt(0));
        attachment2.setId(((JSONArray)res.getData()).getInt(1));
        this.clean.add(attachment);
        this.clean.add(attachment2);
        this.assertFilename((AttachmentMetadata)this.clean.get(0), this.testFile.getName());
        this.assertFilename((AttachmentMetadata)this.clean.get(1), this.testFile2.getName());
    }

    protected final void assertFilename(AttachmentMetadata att, String filename) throws MalformedURLException, JSONException, IOException, SAXException {
        Response res = this.get(this.getWebConversation(), this.sessionId, this.folderId, this.attachedId, this.moduleId, att.getId());
        AbstractAttachmentTest.assertNoError(res);
        JSONObject data = (JSONObject)res.getData();
        AbstractAttachmentTest.assertEquals((String)filename, (String)data.getString("filename"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDocument() throws Exception {
        this.upload();
        InputStream data = null;
        InputStream local = null;
        try {
            data = this.document(this.getWebConversation(), this.sessionId, this.folderId, this.attachedId, this.moduleId, ((AttachmentMetadata)this.clean.get(0)).getId());
            local = new FileInputStream(this.testFile);
            OXTestToolkit.assertSameContent(local, data);
        }
        finally {
            if (data != null) {
                data.close();
            }
            if (local != null) {
                local.close();
            }
        }
        GetMethodWebRequest req = this.documentRequest(this.sessionId, this.folderId, this.attachedId, this.moduleId, ((AttachmentMetadata)this.clean.get(0)).getId(), null);
        WebResponse resp = this.getWebConversation().getResource((WebRequest)req);
        AbstractAttachmentTest.assertEquals((String)"text/plain", (String)resp.getContentType());
        req = this.documentRequest(this.sessionId, this.folderId, this.attachedId, this.moduleId, ((AttachmentMetadata)this.clean.get(0)).getId(), "application/octet-stream");
        resp = this.getWebConversation().getResource((WebRequest)req);
        AbstractAttachmentTest.assertEquals((String)"application/octet-stream", (String)resp.getContentType());
    }

    protected void doNotExists() throws Exception {
        int imaginaryFolderFriend = Integer.MAX_VALUE;
        int imaginaryObjectFriend = Integer.MAX_VALUE;
        AttachmentImpl attachment = new AttachmentImpl();
        attachment.setFolderId(Integer.MAX_VALUE);
        attachment.setAttachedId(this.attachedId);
        attachment.setModuleId(this.moduleId);
        Response res = this.attach(this.getWebConversation(), this.sessionId, Integer.MAX_VALUE, this.attachedId, this.moduleId, this.testFile);
        AbstractAttachmentTest.assertTrue((boolean)res.hasError());
        attachment.setFolderId(this.folderId);
        attachment.setAttachedId(Integer.MAX_VALUE);
        res = this.attach(this.getWebConversation(), this.sessionId, Integer.MAX_VALUE, this.attachedId, this.moduleId, this.testFile);
        AbstractAttachmentTest.assertTrue((boolean)res.hasError());
    }

    protected void doForbidden() throws Exception {
        AttachmentImpl attachment = new AttachmentImpl();
        attachment.setFolderId(this.folderId);
        attachment.setAttachedId(this.attachedId);
        attachment.setModuleId(this.moduleId);
        Response res = this.attach(this.getSecondWebConversation(), this.getSecondSessionId(), this.folderId, this.attachedId, this.moduleId, this.testFile);
        AbstractAttachmentTest.assertTrue((boolean)res.hasError());
    }

    public void refreshSessionId() throws IOException, JSONException, OXException {
        this.sessionId = LoginTest.getSessionId(this.getWebConversation(), this.getHostName(), this.getLogin(), this.getPassword());
    }

    protected void doQuota() throws Exception {
        Response res = this.quota(this.getWebConversation(), this.sessionId);
        AbstractAttachmentTest.assertNoError(res);
        JSONObject quota = (JSONObject)res.getData();
        int use = quota.getInt("use");
        this.upload();
        res = this.quota(this.getWebConversation(), this.sessionId);
        AbstractAttachmentTest.assertNoError(res);
        quota = (JSONObject)res.getData();
        int useAfter = quota.getInt("use");
        res = this.get(this.getWebConversation(), this.sessionId, ((AttachmentMetadata)this.clean.get(0)).getFolderId(), ((AttachmentMetadata)this.clean.get(0)).getAttachedId(), ((AttachmentMetadata)this.clean.get(0)).getAttachedId(), ((AttachmentMetadata)this.clean.get(0)).getId());
        AbstractAttachmentTest.assertNoError(res);
        AbstractAttachmentTest.assertEquals((Object)(useAfter - use), (Object)((JSONObject)res.getData()).get("file_size"));
    }

    protected void doDatasource() throws MalformedURLException, JSONException, IOException, SAXException {
        HashMap<String, Object> datasourceDefinition = new HashMap<String, Object>();
        datasourceDefinition.put("identifier", "com.openexchange.url.mail.attachment");
        datasourceDefinition.put("url", "http://one-finger-salute.org/img/middle_finger.png");
        Response res = this.attach(this.getWebConversation(), this.sessionId, this.folderId, this.attachedId, this.moduleId, datasourceDefinition);
        AttachmentImpl attachment = new AttachmentImpl();
        attachment.setFolderId(this.folderId);
        attachment.setAttachedId(this.attachedId);
        attachment.setModuleId(this.moduleId);
        OXException exception = res.getException();
        if (null != exception) {
            StringWriter writer = new StringWriter(512);
            exception.printStackTrace(new PrintWriter(writer));
            AbstractAttachmentTest.assertNull((String)("An exception occurred: " + writer.toString()), (Object)((Object)exception));
        }
        Integer data = (Integer)res.getData();
        AbstractAttachmentTest.assertNotNull((String)"Response's data is null.", (Object)data);
        attachment.setId(data.intValue());
        this.clean.add(attachment);
        res = this.get(this.getWebConversation(), this.sessionId, this.folderId, this.attachedId, this.moduleId, ((AttachmentMetadata)this.clean.get(0)).getId());
        AbstractAttachmentTest.assertFalse((boolean)res.hasError());
    }

    public void upload() throws Exception {
        AttachmentImpl attachment = new AttachmentImpl();
        attachment.setFolderId(this.folderId);
        attachment.setAttachedId(this.attachedId);
        attachment.setModuleId(this.moduleId);
        Response res = this.attach(this.getWebConversation(), this.sessionId, this.folderId, this.attachedId, this.moduleId, this.testFile);
        AbstractAttachmentTest.assertNoError(res);
        attachment.setId(((JSONArray)res.getData()).getInt(0));
        this.clean.add(attachment);
    }

    public AttachmentMetadata getAttachment(int index) {
        return (AttachmentMetadata)this.clean.get(index);
    }

    public File getTestFile() {
        return this.testFile;
    }
}

