/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.appointment.CalendarTestManagerTest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.test.CalendarTestManager;
import java.util.ArrayList;

public class Bug15903Test
extends CalendarTestManagerTest {
    public Bug15903Test(String name) {
        super(name);
    }

    public void testUpdatedParticipants() throws Exception {
        Appointment appointment = this.generateAppointment();
        appointment.setIgnoreConflicts(true);
        AJAXClient client2 = new AJAXClient(AJAXClient.User.User2);
        int firstUserId = this.getClient().getValues().getUserId();
        int secondUserId = client2.getValues().getUserId();
        appointment.addParticipant((Participant)new UserParticipant(secondUserId));
        appointment = this.calendarMgr.insert(appointment);
        boolean firstUserParticipantInInitialAppointment = false;
        boolean secondUserParticipantInInitialAppointment = false;
        boolean firstUserUserInInitialAppointment = false;
        boolean secondUserUserInInitialAppointment = false;
        boolean firstUserParticipantInUpdatedAppointment = false;
        boolean secondUserParticipantInUpdatedAppointment = false;
        boolean firstUserUserInUpdatedAppointment = false;
        boolean secondUserUserInUpdatedAppointment = false;
        Appointment reload = this.calendarMgr.get(appointment);
        for (Participant participant : reload.getParticipants()) {
            if (participant.getIdentifier() == firstUserId) {
                firstUserParticipantInInitialAppointment = true;
            }
            if (participant.getIdentifier() != secondUserId) continue;
            secondUserParticipantInInitialAppointment = true;
        }
        for (Participant participant : reload.getUsers()) {
            if (participant.getIdentifier() == firstUserId) {
                firstUserUserInInitialAppointment = true;
            }
            if (participant.getIdentifier() != secondUserId) continue;
            secondUserUserInInitialAppointment = true;
        }
        for (Participant participant : reload.getConfirmations()) {
        }
        Bug15903Test.assertTrue((String)"First User should be Participant in the initial appointment", (boolean)firstUserParticipantInInitialAppointment);
        Bug15903Test.assertTrue((String)"Second should be Participant in the initial appointment", (boolean)secondUserParticipantInInitialAppointment);
        Bug15903Test.assertTrue((String)"First User should be User in the initial appointment", (boolean)firstUserUserInInitialAppointment);
        Bug15903Test.assertTrue((String)"Second should be User in the initial appointment", (boolean)secondUserUserInInitialAppointment);
        CalendarTestManager calendarMgr2 = new CalendarTestManager(client2);
        Appointment appForSeconduser = calendarMgr2.get(client2.getValues().getPrivateAppointmentFolder(), appointment.getObjectID());
        Bug15903Test.assertEquals((String)"second user should see the appointment initially", (String)appointment.getTitle(), (String)appForSeconduser.getTitle());
        ArrayList<UserParticipant> participants = new ArrayList<UserParticipant>();
        UserParticipant userParticipant = new UserParticipant(this.getClient().getValues().getUserId());
        participants.add(userParticipant);
        ArrayList<UserParticipant> userParticipants = new ArrayList<UserParticipant>();
        UserParticipant uP = new UserParticipant(firstUserId);
        userParticipants.add(uP);
        reload.setParticipants(participants);
        reload.setIgnoreConflicts(true);
        this.calendarMgr.update(reload);
        Appointment reloadAgain = this.calendarMgr.get(appointment);
        for (Participant participant : reloadAgain.getParticipants()) {
            if (participant.getIdentifier() == firstUserId) {
                firstUserParticipantInUpdatedAppointment = true;
            }
            if (participant.getIdentifier() != secondUserId) continue;
            secondUserParticipantInUpdatedAppointment = true;
        }
        for (Participant participant : reloadAgain.getUsers()) {
            if (participant.getIdentifier() == firstUserId) {
                firstUserUserInUpdatedAppointment = true;
            }
            if (participant.getIdentifier() != secondUserId) continue;
            secondUserUserInUpdatedAppointment = true;
        }
        for (Participant participant : reloadAgain.getConfirmations()) {
        }
        Bug15903Test.assertTrue((String)"First User should still be Participant in the updated appointment", (boolean)firstUserParticipantInUpdatedAppointment);
        Bug15903Test.assertFalse((String)"Second should not be Participant in the updated appointment", (boolean)secondUserParticipantInUpdatedAppointment);
        Bug15903Test.assertTrue((String)"First User should still be User in the updated appointment", (boolean)firstUserUserInUpdatedAppointment);
        Bug15903Test.assertFalse((String)"Second should not be User in the updated appointment", (boolean)secondUserUserInUpdatedAppointment);
        boolean gotException = false;
        try {
            appForSeconduser = calendarMgr2.get(client2.getValues().getPrivateAppointmentFolder(), appointment.getObjectID());
        }
        catch (OXException e) {
            gotException = true;
        }
        Bug15903Test.assertTrue((String)"second user should not see the appointment any longer", (boolean)gotException);
        client2.logout();
    }
}

