/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.GetRequest;
import com.openexchange.ajax.appointment.action.GetResponse;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.appointment.action.ListRequest;
import com.openexchange.ajax.appointment.action.UpdateRequest;
import com.openexchange.ajax.appointment.action.UpdateResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.AbstractColumnsResponse;
import com.openexchange.ajax.framework.CommonInsertResponse;
import com.openexchange.ajax.framework.CommonListResponse;
import com.openexchange.ajax.framework.ListIDs;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import java.util.Calendar;
import java.util.TimeZone;

public final class Bug12326Test
extends AbstractAJAXSession {
    private static final int[] columns = new int[]{1, 20, 209, 207, 206};

    public Bug12326Test(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAppointmentException() throws Throwable {
        AJAXClient client = this.getClient();
        int folderId = client.getValues().getPrivateAppointmentFolder();
        TimeZone tz = client.getValues().getTimeZone();
        Appointment series = new Appointment();
        Calendar calendar = TimeTools.createCalendar(tz);
        series.setTitle("Test for bug 12326");
        series.setParentFolderID(folderId);
        series.setIgnoreConflicts(true);
        calendar.set(11, 12);
        series.setStartDate(calendar.getTime());
        calendar.add(10, 1);
        series.setEndDate(calendar.getTime());
        series.setRecurrenceType(1);
        series.setInterval(1);
        series.setOccurrence(5);
        InsertRequest request = new InsertRequest(series, tz);
        CommonInsertResponse response = client.execute(request);
        series.setObjectID(response.getId());
        series.setLastModified(response.getTimestamp());
        try {
            int recurrence_position = 3;
            GetRequest request2 = new GetRequest(folderId, series.getObjectID(), 3);
            GetResponse response2 = client.execute(request2);
            Appointment occurence = response2.getAppointment(tz);
            Bug12326Test.assertEquals((String)"Occurence must have a recurrence position.", (int)3, (int)occurence.getRecurrencePosition());
            Appointment exception = new Appointment();
            exception.setObjectID(occurence.getObjectID());
            exception.setParentFolderID(folderId);
            exception.setLastModified(occurence.getLastModified());
            exception.setRecurrencePosition(occurence.getRecurrencePosition());
            exception.setTitle(occurence.getTitle() + "-changed");
            exception.setIgnoreConflicts(true);
            calendar.setTime(occurence.getEndDate());
            exception.setStartDate(calendar.getTime());
            calendar.add(10, 1);
            exception.setEndDate(calendar.getTime());
            AJAXRequest<UpdateResponse> request3 = new UpdateRequest(exception, tz);
            AbstractAJAXResponse response3 = client.execute(request3);
            int exceptionId = ((UpdateResponse)response3).getId();
            series.setLastModified(response3.getTimestamp());
            GetRequest request4 = new GetRequest(folderId, exceptionId);
            GetResponse response4 = client.execute(request4);
            Appointment exception2 = response4.getAppointment(tz);
            series.setLastModified(exception2.getLastModified());
            Bug12326Test.assertEquals((String)"Exception is still a series.", (int)0, (int)exception2.getRecurrenceType());
            Bug12326Test.assertEquals((String)"Exception must have a recurrence position.", (int)occurence.getRecurrencePosition(), (int)exception2.getRecurrencePosition());
            Bug12326Test.assertEquals((String)"Exception is missing reference to series.", (int)series.getObjectID(), (int)exception2.getRecurrenceID());
            ListIDs ids = ListIDs.l(new int[][]{{folderId, exceptionId}});
            request3 = new ListRequest(ids, columns);
            response3 = (CommonListResponse)((Object)client.execute(request3));
            Object[] data = ((AbstractColumnsResponse)response3).getArray()[0];
            Bug12326Test.assertEquals((String)"Exception is still a series.", (Object)0, (Object)data[2]);
            Bug12326Test.assertEquals((String)"Exception must have a recurrence position.", (Object)occurence.getRecurrencePosition(), (Object)data[3]);
            Bug12326Test.assertEquals((String)"Exception is missing reference to series.", (Object)series.getObjectID(), (Object)data[4]);
            series.setLastModified(response3.getTimestamp());
        }
        finally {
            client.execute(new DeleteRequest(series.getObjectID(), folderId, series.getLastModified()));
        }
    }
}

