/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment;

import com.openexchange.ajax.AppointmentTest;
import com.openexchange.ajax.ContactTest;
import com.openexchange.ajax.FolderTest;
import com.openexchange.ajax.ResourceTest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.group.GroupTest;
import com.openexchange.ajax.resource.ResourceTools;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.container.GroupParticipant;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.ResourceParticipant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.server.impl.OCLPermission;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class NewTest
extends AppointmentTest {
    public NewTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testSimple() throws Exception {
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testSimple");
        appointmentObj.setStartDate(new Date(startTime));
        appointmentObj.setEndDate(new Date(endTime));
        appointmentObj.setOrganizer(AJAXClient.User.User1.name());
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setIgnoreConflicts(true);
        int objectId = NewTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setObjectID(objectId);
        Appointment loadAppointment = NewTest.loadAppointment(this.getWebConversation(), objectId, appointmentFolderId, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        this.compareObject(appointmentObj, loadAppointment, startTime, endTime);
        NewTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
    }

    public void testFullTime() throws Exception {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(TimeZone.getTimeZone("UTC"));
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        Date start = c.getTime();
        c.add(5, 1);
        Date end = c.getTime();
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testFullTime");
        appointmentObj.setStartDate(start);
        appointmentObj.setEndDate(end);
        appointmentObj.setOrganizer(AJAXClient.User.User1.name());
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setIgnoreConflicts(true);
        appointmentObj.setFullTime(true);
        int objectId = NewTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setObjectID(objectId);
        Appointment loadAppointment = NewTest.loadAppointment(this.getWebConversation(), objectId, appointmentFolderId, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        this.compareObject(appointmentObj, loadAppointment, start.getTime(), end.getTime());
        NewTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
    }

    public void testFullTimeOverTwoDays() throws Exception {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(TimeZone.getTimeZone("UTC"));
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        Date start = c.getTime();
        c.add(5, 2);
        Date end = c.getTime();
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testFullTime");
        appointmentObj.setStartDate(start);
        appointmentObj.setEndDate(end);
        appointmentObj.setOrganizer(AJAXClient.User.User1.name());
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setIgnoreConflicts(true);
        appointmentObj.setFullTime(true);
        int objectId = NewTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setObjectID(objectId);
        Appointment loadAppointment = NewTest.loadAppointment(this.getWebConversation(), objectId, appointmentFolderId, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        this.compareObject(appointmentObj, loadAppointment, start.getTime(), end.getTime());
        NewTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
    }

    public void testServerShouldRoundDownFullTimeAppointments() throws Exception {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(TimeZone.getTimeZone("UTC"));
        c.set(11, 12);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        Date start = c.getTime();
        c.set(11, 13);
        Date end = c.getTime();
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        Date expectedStart = c.getTime();
        c.add(5, 1);
        Date expectedEnd = c.getTime();
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testFullTime rounds down");
        appointmentObj.setStartDate(start);
        appointmentObj.setEndDate(end);
        appointmentObj.setOrganizer(AJAXClient.User.User1.name());
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setIgnoreConflicts(true);
        appointmentObj.setFullTime(true);
        int objectId = NewTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setObjectID(objectId);
        Appointment loadAppointment = NewTest.loadAppointment(this.getWebConversation(), objectId, appointmentFolderId, c.getTimeZone(), "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setStartDate(expectedStart);
        appointmentObj.setEndDate(expectedEnd);
        this.compareObject(appointmentObj, loadAppointment, expectedStart.getTime(), expectedEnd.getTime());
        NewTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
    }

    public void testShouldRoundFullTimeSeriesAsWell() throws Exception {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(TimeZone.getTimeZone("UTC"));
        c.set(5, 1);
        c.set(2, 3);
        c.set(11, 12);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        Date start = c.getTime();
        c.set(11, 13);
        Date end = c.getTime();
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        Date expectedStart = c.getTime();
        c.add(5, 1);
        Date expectedEnd = c.getTime();
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testFullTime rounds down");
        appointmentObj.setStartDate(start);
        appointmentObj.setEndDate(end);
        appointmentObj.setOrganizer(AJAXClient.User.User1.name());
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setIgnoreConflicts(true);
        appointmentObj.setFullTime(true);
        appointmentObj.setRecurrenceType(4);
        appointmentObj.setInterval(1);
        appointmentObj.setDayInMonth(1);
        appointmentObj.setMonth(3);
        int objectId = NewTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setObjectID(objectId);
        Appointment loadAppointment = NewTest.loadAppointment(this.getWebConversation(), objectId, appointmentFolderId, c.getTimeZone(), "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setStartDate(expectedStart);
        appointmentObj.setEndDate(expectedEnd);
        this.compareObject(appointmentObj, loadAppointment, expectedStart.getTime(), expectedEnd.getTime());
        loadAppointment = NewTest.loadAppointment(this.getWebConversation(), objectId, 2, appointmentFolderId, c.getTimeZone(), "http://" + this.getHostName(), this.getSessionId());
        GregorianCalendar check = new GregorianCalendar();
        ((Calendar)check).setTimeZone(c.getTimeZone());
        check.setTime(loadAppointment.getStartDate());
        NewTest.assertEquals((int)0, (int)check.get(11));
        NewTest.assertEquals((int)0, (int)check.get(12));
        NewTest.assertEquals((int)0, (int)check.get(13));
        NewTest.assertEquals((int)0, (int)check.get(14));
        check.setTime(loadAppointment.getEndDate());
        NewTest.assertEquals((int)0, (int)check.get(11));
        NewTest.assertEquals((int)0, (int)check.get(12));
        NewTest.assertEquals((int)0, (int)check.get(13));
        NewTest.assertEquals((int)0, (int)check.get(14));
        NewTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
    }

    public void testUserParticipant() throws Exception {
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testUserParticipant");
        appointmentObj.setStartDate(new Date(startTime));
        appointmentObj.setEndDate(new Date(endTime));
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setIgnoreConflicts(true);
        int userParticipantId = ContactTest.searchContact(this.getWebConversation(), this.userParticipant2, 6, new int[]{524}, "http://" + this.getHostName(), this.getSessionId())[0].getInternalUserId();
        Participant[] participants = new Participant[]{new UserParticipant(this.userId), new UserParticipant(userParticipantId)};
        appointmentObj.setParticipants(participants);
        int objectId = NewTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setObjectID(objectId);
        Appointment loadAppointment = NewTest.loadAppointment(this.getWebConversation(), objectId, appointmentFolderId, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        this.compareObject(appointmentObj, loadAppointment, startTime, endTime);
        NewTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
    }

    public void testGroupParticipant() throws Exception {
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testGroupParticipant");
        appointmentObj.setStartDate(new Date(startTime));
        appointmentObj.setEndDate(new Date(endTime));
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setIgnoreConflicts(true);
        ContactTest.searchContact(this.getWebConversation(), this.userParticipant2, 6, new int[]{524}, "http://" + this.getHostName(), this.getSessionId())[0].getInternalUserId();
        int groupParticipantId = GroupTest.searchGroup(this.getWebConversation(), this.groupParticipant, "http://", this.getHostName(), this.getSessionId())[0].getIdentifier();
        Participant[] participants = new Participant[]{new UserParticipant(this.userId), new GroupParticipant(groupParticipantId)};
        appointmentObj.setParticipants(participants);
        int objectId = NewTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setObjectID(objectId);
        Appointment loadAppointment = NewTest.loadAppointment(this.getWebConversation(), objectId, appointmentFolderId, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        this.compareObject(appointmentObj, loadAppointment, startTime, endTime);
        NewTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
    }

    public void testResourceParticipant() throws Exception {
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testResourceParticipant");
        appointmentObj.setStartDate(new Date(startTime));
        appointmentObj.setEndDate(new Date(endTime));
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setIgnoreConflicts(true);
        int resourceParticipantId = ResourceTest.searchResource(this.getWebConversation(), this.resourceParticipant, "http://" + this.getHostName(), this.getSessionId())[0].getIdentifier();
        Participant[] participants = new Participant[]{new UserParticipant(this.userId), new ResourceParticipant(resourceParticipantId)};
        appointmentObj.setParticipants(participants);
        int objectId = NewTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setObjectID(objectId);
        Appointment loadAppointment = NewTest.loadAppointment(this.getWebConversation(), objectId, appointmentFolderId, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        this.compareObject(appointmentObj, loadAppointment, startTime, endTime);
        NewTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
    }

    public void testAllParticipants() throws Exception {
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testAllParticipants");
        appointmentObj.setStartDate(new Date(startTime));
        appointmentObj.setEndDate(new Date(endTime));
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setIgnoreConflicts(true);
        ContactTest.searchContact(this.getWebConversation(), this.userParticipant2, 6, new int[]{524}, "http://" + this.getHostName(), this.getSessionId())[0].getInternalUserId();
        int groupParticipantId = GroupTest.searchGroup(this.getWebConversation(), this.groupParticipant, "http://", this.getHostName(), this.getSessionId())[0].getIdentifier();
        int resourceParticipantId = ResourceTest.searchResource(this.getWebConversation(), this.resourceParticipant, "http://" + this.getHostName(), this.getSessionId())[0].getIdentifier();
        Participant[] participants = new Participant[]{new UserParticipant(this.userId), new ResourceParticipant(resourceParticipantId), new GroupParticipant(groupParticipantId)};
        appointmentObj.setParticipants(participants);
        int objectId = NewTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setObjectID(objectId);
        Appointment loadAppointment = NewTest.loadAppointment(this.getWebConversation(), objectId, appointmentFolderId, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        this.compareObject(appointmentObj, loadAppointment, startTime, endTime);
        NewTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
    }

    public void testSpecialCharacters() throws Exception {
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testSpecialCharacters - \u00f6\u00e4\u00fc-:,;.#?!\u00a7$%&/()=\"<>");
        appointmentObj.setStartDate(new Date(startTime));
        appointmentObj.setEndDate(new Date(endTime));
        appointmentObj.setOrganizer(AJAXClient.User.User1.name());
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setIgnoreConflicts(true);
        int objectId = NewTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setObjectID(objectId);
        Appointment loadAppointment = NewTest.loadAppointment(this.getWebConversation(), objectId, appointmentFolderId, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        this.compareObject(appointmentObj, loadAppointment, startTime, endTime);
        NewTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
    }

    public void testPrivateFolder() throws Exception {
        FolderObject folderObj = com.openexchange.webdav.xml.FolderTest.createFolderObject(this.userId, "testPrivateFolder" + System.currentTimeMillis(), 2, false);
        int targetFolder = com.openexchange.webdav.xml.FolderTest.insertFolder(this.getWebConversation(), folderObj, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), "");
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testPrivateFolder");
        appointmentObj.setStartDate(new Date(startTime));
        appointmentObj.setEndDate(new Date(endTime));
        appointmentObj.setOrganizer(AJAXClient.User.User1.name());
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(targetFolder);
        appointmentObj.setIgnoreConflicts(true);
        int objectId = NewTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setObjectID(objectId);
        Appointment loadAppointment = NewTest.loadAppointment(this.getWebConversation(), objectId, targetFolder, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        this.compareObject(appointmentObj, loadAppointment, startTime, endTime);
        NewTest.deleteAppointment(this.getWebConversation(), objectId, targetFolder, "http://" + this.getHostName(), this.getSessionId(), false);
        com.openexchange.webdav.xml.FolderTest.deleteFolder(this.getWebConversation(), new int[]{targetFolder}, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), "");
    }

    public void testPublicFolder() throws Exception {
        FolderObject folderObj = com.openexchange.webdav.xml.FolderTest.createFolderObject(this.userId, "testPublicFolder" + System.currentTimeMillis(), 2, true);
        int targetFolder = com.openexchange.webdav.xml.FolderTest.insertFolder(this.getWebConversation(), folderObj, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), "");
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testPrivateFolder");
        appointmentObj.setStartDate(new Date(startTime));
        appointmentObj.setEndDate(new Date(endTime));
        appointmentObj.setOrganizer(AJAXClient.User.User1.name());
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(targetFolder);
        appointmentObj.setIgnoreConflicts(true);
        int objectId = NewTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setObjectID(objectId);
        Appointment loadAppointment = NewTest.loadAppointment(this.getWebConversation(), objectId, targetFolder, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        this.compareObject(appointmentObj, loadAppointment, startTime, endTime);
        NewTest.deleteAppointment(this.getWebConversation(), objectId, targetFolder, "http://" + this.getHostName(), this.getSessionId(), false);
        com.openexchange.webdav.xml.FolderTest.deleteFolder(this.getWebConversation(), new int[]{targetFolder}, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), "");
    }

    public void testSharedFolder() throws Exception {
        FolderObject sharedFolderObject = FolderTest.getStandardCalendarFolder(this.getSecondWebConversation(), this.getHostName(), this.getSecondSessionId());
        int secondUserId = sharedFolderObject.getCreatedBy();
        FolderObject folderObj = com.openexchange.webdav.xml.FolderTest.createFolderObject(this.userId, "testSharedFolder" + System.currentTimeMillis(), 2, false);
        OCLPermission[] permission = new OCLPermission[]{com.openexchange.webdav.xml.FolderTest.createPermission(this.userId, false, 128, 128, 128, 128), com.openexchange.webdav.xml.FolderTest.createPermission(secondUserId, false, 4, 128, 128, 128, false)};
        folderObj.setPermissionsAsArray(permission);
        int targetFolder = com.openexchange.webdav.xml.FolderTest.insertFolder(this.getWebConversation(), folderObj, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), "");
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testSharedFolder");
        appointmentObj.setStartDate(new Date(startTime));
        appointmentObj.setEndDate(new Date(endTime));
        appointmentObj.setOrganizer(AJAXClient.User.User1.name());
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(targetFolder);
        appointmentObj.setIgnoreConflicts(true);
        int objectId = NewTest.insertAppointment(this.getSecondWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSecondSessionId());
        appointmentObj.setObjectID(objectId);
        Appointment loadAppointment = NewTest.loadAppointment(this.getSecondWebConversation(), objectId, targetFolder, this.timeZone, "http://" + this.getHostName(), this.getSecondSessionId());
        this.compareObject(appointmentObj, loadAppointment, startTime, endTime);
        try {
            NewTest.deleteAppointment(this.getSecondWebConversation(), objectId, targetFolder, "http://" + this.getHostName(), this.getSecondSessionId(), false);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            com.openexchange.webdav.xml.FolderTest.deleteFolder(this.getWebConversation(), new int[]{targetFolder}, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), "");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testDailyRecurrence() throws Exception {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(TimeZone.getTimeZone("UTC"));
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        Date until = new Date(c.getTimeInMillis() + 1296000000L);
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testDailyRecurrence");
        appointmentObj.setStartDate(new Date(startTime));
        appointmentObj.setEndDate(new Date(endTime));
        appointmentObj.setOrganizer(AJAXClient.User.User1.name());
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setRecurrenceType(1);
        appointmentObj.setInterval(1);
        appointmentObj.setUntil(until);
        appointmentObj.setIgnoreConflicts(true);
        int objectId = NewTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setObjectID(objectId);
        Appointment loadAppointment = NewTest.loadAppointment(this.getWebConversation(), objectId, appointmentFolderId, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        this.compareObject(appointmentObj, loadAppointment, startTime, endTime);
        NewTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
    }

    public void testWeeklyRecurrence() throws Exception {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(TimeZone.getTimeZone("UTC"));
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        Date until = new Date(c.getTimeInMillis() + 864000000L);
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testWeeklyRecurrence");
        appointmentObj.setStartDate(new Date(startTime));
        appointmentObj.setEndDate(new Date(endTime));
        appointmentObj.setOrganizer(AJAXClient.User.User1.name());
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setRecurrenceType(2);
        appointmentObj.setDays(127);
        appointmentObj.setInterval(1);
        appointmentObj.setUntil(until);
        appointmentObj.setIgnoreConflicts(true);
        int objectId = NewTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setObjectID(objectId);
        Appointment loadAppointment = NewTest.loadAppointment(this.getWebConversation(), objectId, appointmentFolderId, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        this.compareObject(appointmentObj, loadAppointment, startTime, endTime);
        NewTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
    }

    public void testMonthlyRecurrenceDayInMonth() throws Exception {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(TimeZone.getTimeZone("UTC"));
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        Date until = new Date(c.getTimeInMillis() + 5184000000L);
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testMonthlyRecurrenceDayInMonth");
        appointmentObj.setStartDate(new Date(startTime));
        appointmentObj.setEndDate(new Date(endTime));
        appointmentObj.setOrganizer(AJAXClient.User.User1.name());
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setRecurrenceType(3);
        appointmentObj.setDayInMonth(15);
        appointmentObj.setInterval(1);
        appointmentObj.setUntil(until);
        appointmentObj.setIgnoreConflicts(true);
        int objectId = NewTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setObjectID(objectId);
        Appointment loadAppointment = NewTest.loadAppointment(this.getWebConversation(), objectId, appointmentFolderId, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        this.compareObject(appointmentObj, loadAppointment, loadAppointment.getStartDate().getTime(), loadAppointment.getEndDate().getTime());
        NewTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
    }

    public void testMonthlyRecurrenceDays() throws Exception {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(TimeZone.getTimeZone("UTC"));
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        Date until = new Date(c.getTimeInMillis() + 7776000000L);
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testMonthlyRecurrenceDays");
        appointmentObj.setStartDate(new Date(startTime));
        appointmentObj.setEndDate(new Date(endTime));
        appointmentObj.setOrganizer(AJAXClient.User.User1.name());
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setRecurrenceType(3);
        appointmentObj.setDays(8);
        appointmentObj.setDayInMonth(3);
        appointmentObj.setInterval(2);
        appointmentObj.setUntil(until);
        appointmentObj.setIgnoreConflicts(true);
        int objectId = NewTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setObjectID(objectId);
        Appointment loadAppointment = NewTest.loadAppointment(this.getWebConversation(), objectId, appointmentFolderId, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        this.compareObject(appointmentObj, loadAppointment, loadAppointment.getStartDate().getTime(), loadAppointment.getEndDate().getTime());
        NewTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
    }

    public void testYearlyRecurrenceDayInMonth() throws Exception {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(TimeZone.getTimeZone("UTC"));
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        Date until = new Date(c.getTimeInMillis() + 69120000000L);
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testYearlyRecurrenceDayInMonth");
        appointmentObj.setStartDate(new Date(startTime));
        appointmentObj.setEndDate(new Date(endTime));
        appointmentObj.setOrganizer(AJAXClient.User.User1.name());
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setRecurrenceType(4);
        appointmentObj.setMonth(6);
        appointmentObj.setDayInMonth(15);
        appointmentObj.setInterval(1);
        appointmentObj.setUntil(until);
        appointmentObj.setIgnoreConflicts(true);
        int objectId = NewTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setObjectID(objectId);
        Appointment loadAppointment = NewTest.loadAppointment(this.getWebConversation(), objectId, appointmentFolderId, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        this.compareObject(appointmentObj, loadAppointment, loadAppointment.getStartDate().getTime(), loadAppointment.getEndDate().getTime());
        NewTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
    }

    public void testYearlyRecurrenceDays() throws Exception {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(TimeZone.getTimeZone("UTC"));
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        Date until = new Date(c.getTimeInMillis() + 69120000000L);
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testYearlyRecurrenceDays");
        appointmentObj.setStartDate(new Date(startTime));
        appointmentObj.setEndDate(new Date(endTime));
        appointmentObj.setOrganizer(AJAXClient.User.User1.name());
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setRecurrenceType(4);
        appointmentObj.setMonth(6);
        appointmentObj.setDays(8);
        appointmentObj.setDayInMonth(3);
        appointmentObj.setInterval(2);
        appointmentObj.setUntil(until);
        appointmentObj.setIgnoreConflicts(true);
        int objectId = NewTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setObjectID(objectId);
        Appointment loadAppointment = NewTest.loadAppointment(this.getWebConversation(), objectId, appointmentFolderId, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        this.compareObject(appointmentObj, loadAppointment, loadAppointment.getStartDate().getTime(), loadAppointment.getEndDate().getTime());
        NewTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
    }

    public void testConflict() throws Exception {
        int objectId2;
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testConflict");
        appointmentObj.setStartDate(new Date(startTime));
        appointmentObj.setEndDate(new Date(endTime));
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setIgnoreConflicts(true);
        int objectId1 = NewTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        try {
            appointmentObj.setIgnoreConflicts(false);
            objectId2 = NewTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
            NewTest.deleteAppointment(this.getWebConversation(), objectId2, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), true);
            NewTest.fail((String)"conflict exception expected here!");
        }
        catch (OXException exc) {
            NewTest.assertTrue((boolean)true);
        }
        appointmentObj.setIgnoreConflicts(true);
        objectId2 = NewTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        NewTest.deleteAppointment(this.getWebConversation(), objectId2, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
        NewTest.deleteAppointment(this.getWebConversation(), objectId1, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
    }

    public void testConflictWithResource() throws Exception {
        int objectId2;
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testConflictWithResource");
        appointmentObj.setStartDate(new Date(startTime));
        appointmentObj.setEndDate(new Date(endTime));
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setIgnoreConflicts(true);
        int resourceParticipantId = ResourceTools.getSomeResource(this.getClient());
        Participant[] participants = new Participant[]{new UserParticipant(this.userId), new ResourceParticipant(resourceParticipantId)};
        appointmentObj.setParticipants(participants);
        int objectId1 = NewTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setIgnoreConflicts(false);
        try {
            objectId2 = NewTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
            NewTest.deleteAppointment(this.getWebConversation(), objectId2, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), true);
            NewTest.assertEquals((String)"conflict expected here object id should be 0", (int)0, (int)objectId2);
        }
        catch (OXException exc) {
            // empty catch block
        }
        appointmentObj.setIgnoreConflicts(true);
        try {
            objectId2 = NewTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
            NewTest.deleteAppointment(this.getWebConversation(), objectId2, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), true);
            NewTest.assertEquals((String)"conflict expected here object id should be 0", (int)0, (int)objectId2);
        }
        catch (OXException exc) {
            NewTest.assertTrue((boolean)true);
        }
        NewTest.deleteAppointment(this.getWebConversation(), objectId1, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
    }
}

