/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange;

import com.meterware.httpunit.AuthorizationRequiredException;
import com.meterware.httpunit.HeadMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.openexchange.ajax.framework.AJAXSession;
import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.session.LoginTools;
import com.openexchange.ajax.session.actions.LoginRequest;
import com.openexchange.ajax.session.actions.LoginResponse;
import com.openexchange.ajax.session.actions.LogoutRequest;
import com.openexchange.configuration.AJAXConfig;
import com.openexchange.exception.OXException;
import java.io.IOException;
import java.util.Random;
import junit.framework.AssertionFailedError;
import org.xml.sax.SAXException;

public final class MixTest {
    private MixTest() {
    }

    public static void main(String[] args) throws InterruptedException {
        int i;
        int count = 3;
        Thread[] ajax = new Thread[3];
        Thread[] webdav = new Thread[3];
        try {
            AJAXConfig.init();
        }
        catch (OXException e) {
            e.printStackTrace();
            return;
        }
        for (i = 0; i < 3; ++i) {
            ajax[i] = new Thread(new AjaxLogin());
            ajax[i].start();
            webdav[i] = new Thread(new WebDAVLogin());
            webdav[i].start();
        }
        for (i = 0; i < 3; ++i) {
            ajax[i].join();
            webdav[i].join();
        }
    }

    private static class WebDAVLogin
    implements Runnable {
        private final Random rand = new Random(System.currentTimeMillis());

        WebDAVLogin() {
        }

        @Override
        public void run() {
            WebConversation conv = new WebConversation();
            HeadMethodWebRequest req = new HeadMethodWebRequest(AJAXConfig.getProperty(AJAXConfig.Property.PROTOCOL) + "://" + AJAXConfig.getProperty(AJAXConfig.Property.HOSTNAME) + "/servlet/webdav.infostore");
            conv.setAuthorization(AJAXConfig.getProperty(AJAXConfig.Property.LOGIN), AJAXConfig.getProperty(AJAXConfig.Property.PASSWORD));
            try {
                while (true) {
                    try {
                        WebResponse resp = conv.getResponse((WebRequest)req);
                        if (resp.getResponseCode() != 200 || !"httpd/unix-directory".equals(resp.getContentType())) {
                            System.out.println("discovered mod_jk problem!");
                        }
                        if (resp.getResponseCode() == 200 && resp.getContentType().startsWith("text/javascript")) {
                            System.out.println("Invalid body found! \"" + resp.getText() + "\"");
                        }
                    }
                    catch (AuthorizationRequiredException e) {
                        System.out.println("Login failed.");
                    }
                    Thread.sleep(this.rand.nextInt(10));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
        }
    }

    private static class AjaxLogin
    implements Runnable {
        private final AJAXSession session = new AJAXSession();
        private final LoginRequest request = new LoginRequest(AJAXConfig.getProperty(AJAXConfig.Property.LOGIN), AJAXConfig.getProperty(AJAXConfig.Property.PASSWORD), LoginTools.generateAuthId(), MixTest.class.getName(), "6.15.0");
        private final Random rand = new Random(System.currentTimeMillis());

        AjaxLogin() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                LoginResponse resp = null;
                try {
                    resp = Executor.execute(this.session, this.request);
                    this.session.setId(resp.getSessionId());
                    Executor.execute(this.session, new LogoutRequest());
                    this.session.setId(null);
                    continue;
                }
                catch (AssertionFailedError e) {
                    System.out.println("Login failed! " + e.getMessage());
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    continue;
                }
                finally {
                    this.session.getConversation().clearContents();
                    try {
                        Thread.sleep(this.rand.nextInt(10));
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                break;
            }
        }
    }
}

