/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.action;

import com.openexchange.java.Charsets;
import com.openexchange.java.Streams;
import com.openexchange.log.LogFactory;
import com.openexchange.webdav.action.AbstractAction;
import com.openexchange.webdav.action.CapturingWebdavResponse;
import com.openexchange.webdav.action.ReplayWebdavRequest;
import com.openexchange.webdav.action.WebdavRequest;
import com.openexchange.webdav.action.WebdavResponse;
import com.openexchange.webdav.protocol.WebdavProtocolException;
import com.openexchange.webdav.protocol.WebdavResource;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;

public class WebdavLogAction
extends AbstractAction {
    private static final Set<String> CONFIDENTIAL_HEADERS = new HashSet<String>(){
        {
            this.add("AUTHORIZATION");
        }
    };
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(WebdavLogAction.class));
    private boolean logBody;
    private boolean logResponse;

    @Override
    public void perform(WebdavRequest req, WebdavResponse res) throws WebdavProtocolException {
        StringBuilder b = new StringBuilder();
        try {
            b.append("URL: ");
            b.append(req.getUrl());
            b.append('\n');
            for (String header : req.getHeaderNames()) {
                if (CONFIDENTIAL_HEADERS.contains(header.toUpperCase())) {
                    b.append(header);
                    b.append(": ");
                    b.append("xxxxxxxxxxx");
                    b.append('\n');
                    continue;
                }
                b.append(header);
                b.append(": ");
                b.append(req.getHeader(header));
                b.append('\n');
            }
            WebdavResource resource = req.getResource();
            b.append("Resource: ");
            b.append(resource);
            b.append('\n');
            b.append("exists: ");
            b.append(resource.exists());
            b.append('\n');
            b.append("isCollection: ");
            b.append(resource.isCollection());
            b.append('\n');
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)b.toString());
            }
            if (LOG.isTraceEnabled()) {
                if (this.logBody) {
                    req = new ReplayWebdavRequest(req);
                    this.printRequestBody(req);
                }
                if (this.logResponse) {
                    res = new CapturingWebdavResponse(res);
                }
            }
            this.yield(req, res);
            b = new StringBuilder();
            b.append("DONE URL: ");
            b.append(req.getUrl());
            b.append(' ');
            b.append(res.getStatus());
            b.append('\n');
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)b.toString());
            }
            if (LOG.isTraceEnabled() && this.logResponse) {
                LOG.trace((Object)((CapturingWebdavResponse)res).getBodyAsString());
            }
        }
        catch (WebdavProtocolException x) {
            b = new StringBuilder();
            b.append("Status: ");
            b.append(x.getMessage());
            b.append(' ');
            b.append(x.getStatus());
            b.append('\n');
            b.append("WebdavException: ");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)b.toString(), (Throwable)((Object)x));
            } else if (LOG.isErrorEnabled() && x.getStatus() == 500) {
                LOG.error((Object)("The request: " + b.toString() + " caused an internal server error: " + x.getMessage()), (Throwable)((Object)x));
            }
            throw x;
        }
        catch (RuntimeException x) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("RuntimeException In WebDAV for request: " + b.toString()), (Throwable)x);
            }
            throw x;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printRequestBody(WebdavRequest req) {
        if (this.logBody) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(req.getBody(), Charsets.UTF_8));
                String line = null;
                StringBuilder b = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    b.append(line);
                    b.append('\n');
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)b);
                }
                Streams.close((Closeable)reader);
            }
            catch (IOException x) {
                LOG.debug((Object)"", (Throwable)x);
            }
            finally {
                Streams.close(reader);
            }
        }
    }

    public void setLogRequestBody(boolean b) {
        this.logBody = b;
    }

    public void setLogResponseBody(boolean b) {
        this.logResponse = b;
    }

    public boolean isEnabled() {
        return LOG.isErrorEnabled();
    }
}

