/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.versit.valuedefinitions.rfc2445;

import com.openexchange.tools.versit.Property;
import com.openexchange.tools.versit.StringScanner;
import com.openexchange.tools.versit.ValueDefinition;
import com.openexchange.tools.versit.VersitException;
import com.openexchange.tools.versit.values.DurationValue;
import java.io.IOException;

public class DurationValueDefinition
extends ValueDefinition {
    public static final ValueDefinition Default = new DurationValueDefinition();

    @Override
    public Object createValue(StringScanner s, Property property) throws IOException {
        DurationValue dur = new DurationValue();
        if (s.peek == 43) {
            s.read();
        } else if (s.peek == 45) {
            dur.Negative = true;
            s.read();
        }
        if (s.peek != 80) {
            throw new VersitException(s, "Duration expected");
        }
        s.read();
        if (s.peek == 84) {
            this.parseTime(s, dur);
        } else {
            int num = s.parseNumber();
            if (s.peek == 68) {
                dur.Days = num;
                if (s.peek == 84) {
                    this.parseTime(s, dur);
                }
            } else if (s.peek == 87) {
                dur.Weeks = num;
            } else {
                throw new VersitException(s, "Duration expected");
            }
        }
        return dur;
    }

    private void parseTime(StringScanner s, DurationValue dur) throws IOException {
        s.read();
        int num = s.parseNumber();
        switch (s.peek) {
            case 72: {
                this.parseHour(s, num, dur);
                break;
            }
            case 77: {
                this.parseMinute(s, num, dur);
                break;
            }
            case 83: {
                this.parseSecond(s, num, dur);
                break;
            }
            default: {
                throw new VersitException(s, "Duration expected");
            }
        }
    }

    private void parseHour(StringScanner s, int num, DurationValue dur) throws IOException {
        if (s.peek != 72) {
            throw new VersitException(s, "Duration expected");
        }
        s.read();
        dur.Hours = num;
        if (s.peek >= 48 && s.peek <= 57) {
            this.parseMinute(s, s.parseNumber(), dur);
        }
    }

    private void parseMinute(StringScanner s, int num, DurationValue dur) throws IOException {
        if (s.peek != 77) {
            throw new VersitException(s, "Duration expected");
        }
        s.read();
        dur.Minutes = num;
        if (s.peek >= 48 && s.peek <= 57) {
            this.parseSecond(s, s.parseNumber(), dur);
        }
    }

    private void parseSecond(StringScanner s, int num, DurationValue dur) throws IOException {
        if (s.peek != 83) {
            throw new VersitException(s, "Duration expected");
        }
        s.read();
        dur.Seconds = num;
    }

    @Override
    public String writeValue(Object value) {
        DurationValue dur = (DurationValue)value;
        StringBuilder sb = new StringBuilder();
        sb.append(dur.Negative ? "-P" : "P");
        if (dur.Weeks != 0) {
            sb.append(dur.Weeks);
            sb.append('W');
        } else {
            if (dur.Days != 0) {
                sb.append(dur.Days);
                sb.append('D');
            }
            if (dur.Hours != 0 || dur.Minutes != 0 || dur.Seconds != 0) {
                sb.append('T');
                if (dur.Hours != 0) {
                    sb.append(dur.Hours);
                    sb.append('H');
                    if (dur.Minutes != 0 || dur.Seconds != 0) {
                        sb.append(dur.Minutes);
                        sb.append('M');
                        if (dur.Seconds != 0) {
                            sb.append(dur.Seconds);
                            sb.append('S');
                        }
                    }
                } else {
                    if (dur.Minutes != 0) {
                        sb.append(dur.Minutes);
                        sb.append('M');
                    }
                    if (dur.Seconds != 0) {
                        sb.append(dur.Seconds);
                        sb.append('S');
                    }
                }
            }
        }
        return sb.toString();
    }
}

