/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.versit;

import com.openexchange.tools.versit.FoldingWriter;
import com.openexchange.tools.versit.Parameter;
import com.openexchange.tools.versit.ParameterDefinition;
import com.openexchange.tools.versit.ParameterValue;
import com.openexchange.tools.versit.Property;
import com.openexchange.tools.versit.Scanner;
import com.openexchange.tools.versit.ValueDefinition;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;

public class PropertyDefinition {
    public final ValueDefinition value;
    private final HashMap<String, ValueDefinition> Values = new HashMap();
    private final HashMap<String, ParameterDefinition> Parameters = new HashMap();
    public static final PropertyDefinition Default = new PropertyDefinition(new ValueDefinition());

    public PropertyDefinition(ValueDefinition value) {
        this.value = value;
    }

    public PropertyDefinition(ValueDefinition value, String[] valueNames, ValueDefinition[] values, String[] paramNames, ParameterDefinition[] parameters) {
        int i;
        this.value = value;
        for (i = 0; i < values.length; ++i) {
            this.addValue(valueNames[i], values[i]);
        }
        for (i = 0; i < parameters.length; ++i) {
            this.addParameter(paramNames[i], parameters[i]);
        }
    }

    public ParameterDefinition getParameter(String name) {
        ParameterDefinition param = this.Parameters.get(name.toUpperCase(Locale.ENGLISH));
        if (param == null) {
            return ParameterDefinition.Default;
        }
        return param;
    }

    public final void addParameter(String name, ParameterDefinition parameter) {
        this.Parameters.put(name.toUpperCase(Locale.ENGLISH), parameter);
    }

    public ValueDefinition getValue(String name) {
        ValueDefinition value = this.Values.get(name.toUpperCase(Locale.ENGLISH));
        if (value == null) {
            return this.value;
        }
        return value;
    }

    public final void addValue(String name, ValueDefinition value) {
        this.Values.put(name.toUpperCase(Locale.ENGLISH), value);
    }

    public Property parse(Scanner s, String propertyName) throws IOException {
        Object value;
        Property property = new Property(propertyName);
        while (s.peek == 59) {
            s.read();
            String paramName = s.parseName();
            if (paramName.length() == 0) {
                return null;
            }
            if (paramName.equalsIgnoreCase("BASE64")) {
                Parameter encoding = new Parameter("ENCODING");
                encoding.addValue(new ParameterValue("b"));
                property.addParameter(encoding);
                continue;
            }
            Parameter param = this.getParameter(paramName).parse(s, paramName);
            if (param == null) {
                return null;
            }
            property.addParameter(param);
        }
        if (s.peek != 58) {
            return null;
        }
        s.read();
        ValueDefinition valueDefinition = this.value;
        Parameter valueParam = property.getParameter("VALUE");
        if (valueParam != null) {
            valueDefinition = this.getValue(valueParam.getValue(0).getText());
        }
        if ((value = valueDefinition.parse(s, property)) == null) {
            property.markInvalid();
        } else {
            property.setValue(value);
        }
        return property;
    }

    public void write(FoldingWriter fw, Property property) throws IOException {
        fw.write(property.name);
        int count = property.getParameterCount();
        for (int i = 0; i < count; ++i) {
            Parameter parameter = property.getParameter(i);
            ParameterDefinition definition = this.getParameter(parameter.name);
            definition.write(fw, parameter);
        }
        fw.write(":");
        ValueDefinition definition = this.value;
        Parameter valueParameter = property.getParameter("VALUE");
        if (valueParameter != null) {
            definition = this.getValue(valueParameter.getValue(0).getText());
        }
        definition.write(fw, property);
    }
}

