/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.oxfolder.deletelistener.sql;

import com.openexchange.log.LogFactory;
import com.openexchange.tools.oxfolder.deletelistener.CorruptPermission;
import com.openexchange.tools.oxfolder.deletelistener.Permission;
import com.openexchange.tools.oxfolder.deletelistener.sql.MergerUtility;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.logging.Log;

public final class UserPermissionMerger {
    private static final Log LOG = LogFactory.getLog(UserPermissionMerger.class);

    private UserPermissionMerger() {
    }

    public static void handleCorruptUserPermissions(CorruptPermission[] corruptPermissions, Connection con) throws SQLException {
        boolean[] delete = new boolean[1];
        StringBuilder logBuilder = LOG.isInfoEnabled() ? new StringBuilder(128) : null;
        for (CorruptPermission corruptPermission : corruptPermissions) {
            Permission merged;
            int admin = MergerUtility.getContextAdminID(corruptPermission.cid, con);
            delete[0] = false;
            try {
                merged = MergerUtility.getMergedPermission(corruptPermission.permission_id, admin, corruptPermission.fuid, corruptPermission.cid, con, delete);
            }
            catch (IllegalStateException e) {
                continue;
            }
            if (delete[0]) {
                MergerUtility.deletePermission(corruptPermission.permission_id, corruptPermission.fuid, corruptPermission.cid, con);
                if (LOG.isInfoEnabled()) {
                    logBuilder.setLength(0);
                    LOG.info((Object)logBuilder.append("Permission deleted for entity ").append(corruptPermission.permission_id).append(" on folder ").append(corruptPermission.fuid).append(" in context ").append(corruptPermission.cid).toString());
                }
                MergerUtility.updatePermission(merged, admin, admin, corruptPermission.fuid, corruptPermission.cid, con);
                if (!LOG.isInfoEnabled()) continue;
                logBuilder.setLength(0);
                LOG.info((Object)logBuilder.append("...and merged to context admin: ").append(merged.toString()).toString());
                continue;
            }
            MergerUtility.updatePermission(merged, corruptPermission.permission_id, admin, corruptPermission.fuid, corruptPermission.cid, con);
            if (!LOG.isInfoEnabled()) continue;
            logBuilder.setLength(0);
            LOG.info((Object)logBuilder.append("Permission re-assigned to context admin: ").append(merged.toString()).toString());
        }
    }
}

