/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.oxfolder.deletelistener.sql;

import com.openexchange.tools.oxfolder.deletelistener.Permission;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class MergerUtility {
    private static final String SQL_REASSIGN_UPDATE_PERM = "UPDATE oxfolder_permissions SET fp = ?, orp = ?, owp = ?, odp = ?, admin_flag = ?, permission_id = ?, group_flag = 1 WHERE cid = ? AND permission_id = ? AND fuid = ?";
    private static final String SQL_SEL_PERM = "SELECT fp, orp, owp, odp, admin_flag FROM oxfolder_permissions WHERE cid = ? AND permission_id = ? AND fuid = ?";
    private static final String SQL_DELETE_PERM = "DELETE FROM oxfolder_permissions WHERE cid = ? AND permission_id = ? AND fuid = ?";
    private static final String SQL_SELECT_ADMIN = "SELECT user FROM user_setting_admin WHERE cid = ?";

    private MergerUtility() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updatePermission(Permission mergedPerm, int entity, int setToEntity, int fuid, int cid, Connection writeCon) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = writeCon.prepareStatement(SQL_REASSIGN_UPDATE_PERM);
            stmt.setInt(1, mergedPerm.fp);
            stmt.setInt(2, mergedPerm.orp);
            stmt.setInt(3, mergedPerm.owp);
            stmt.setInt(4, mergedPerm.odp);
            stmt.setInt(5, mergedPerm.admin ? 1 : 0);
            stmt.setInt(6, setToEntity);
            stmt.setInt(7, cid);
            stmt.setInt(8, entity);
            stmt.setInt(9, fuid);
            stmt.executeUpdate();
        }
        finally {
            if (null != stmt) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    System.err.println("Warning: Statement could not be properly closed");
                    e.printStackTrace(System.err);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Permission getMergedPermission(int entity, int fallbackEntity, int fuid, int cid, Connection readCon, boolean[] delete) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = readCon.prepareStatement(SQL_SEL_PERM);
            stmt.setInt(1, cid);
            stmt.setInt(2, fallbackEntity);
            stmt.setInt(3, fuid);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                rs.close();
                stmt.close();
                stmt = readCon.prepareStatement(SQL_SEL_PERM);
                stmt.setInt(1, cid);
                stmt.setInt(2, entity);
                stmt.setInt(3, fuid);
                rs = stmt.executeQuery();
                if (!rs.next()) {
                    throw new IllegalStateException(new StringBuilder(64).append("Entity ").append(entity).append(" has no permission on folder ").append(fuid).append(" in context ").append(cid).toString());
                }
                delete[0] = false;
                Permission permission = new Permission(fallbackEntity, fuid, rs.getInt(1), rs.getInt(2), rs.getInt(3), rs.getInt(4), rs.getInt(5) > 0);
                return permission;
            }
            Permission fallbackPerm = new Permission(fallbackEntity, fuid, rs.getInt(1), rs.getInt(2), rs.getInt(3), rs.getInt(4), rs.getInt(5) > 0);
            rs.close();
            stmt.close();
            stmt = readCon.prepareStatement(SQL_SEL_PERM);
            stmt.setInt(1, cid);
            stmt.setInt(2, entity);
            stmt.setInt(3, fuid);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                Permission e = fallbackPerm;
                return e;
            }
            Permission entityPerm = new Permission(entity, fuid, rs.getInt(1), rs.getInt(2), rs.getInt(3), rs.getInt(4), rs.getInt(5) > 0);
            Permission mergedPerm = new Permission(fallbackEntity, fuid, Math.max(fallbackPerm.fp, entityPerm.fp), Math.max(fallbackPerm.orp, entityPerm.orp), Math.max(fallbackPerm.owp, entityPerm.owp), Math.max(fallbackPerm.odp, entityPerm.odp), fallbackPerm.admin || entityPerm.admin);
            delete[0] = true;
            Permission permission = mergedPerm;
            return permission;
        }
        finally {
            if (null != rs) {
                try {
                    rs.close();
                    rs = null;
                }
                catch (SQLException e) {
                    System.err.println("Warning: Result set could not be properly closed");
                    e.printStackTrace(System.err);
                }
            }
            if (null != stmt) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    System.err.println("Warning: Statement could not be properly closed");
                    e.printStackTrace(System.err);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deletePermission(int entity, int fuid, int cid, Connection con) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement(SQL_DELETE_PERM);
            stmt.setInt(1, cid);
            stmt.setInt(2, entity);
            stmt.setInt(3, fuid);
            stmt.executeUpdate();
        }
        finally {
            if (null != stmt) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    System.err.println("Warning: Statement could not be properly closed");
                    e.printStackTrace(System.err);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getContextAdminID(int cid, Connection con) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement(SQL_SELECT_ADMIN);
            stmt.setInt(1, cid);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                int n = -1;
                return n;
            }
            int n = rs.getInt(1);
            return n;
        }
        finally {
            if (null != rs) {
                try {
                    rs.close();
                    rs = null;
                }
                catch (SQLException e) {
                    System.err.println("Warning: Result set could not be properly closed");
                    e.printStackTrace(System.err);
                }
            }
            if (null != stmt) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    System.err.println("Warning: Statement could not be properly closed");
                    e.printStackTrace(System.err);
                }
            }
        }
    }
}

