/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.oxfolder.deletelistener;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.delete.DeleteFailedExceptionCodes;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.oxfolder.deletelistener.CorruptPermission;
import com.openexchange.tools.oxfolder.deletelistener.sql.DetectCorruptPermissions;
import com.openexchange.tools.oxfolder.deletelistener.sql.GroupPermissionMerger;
import com.openexchange.tools.oxfolder.deletelistener.sql.UserPermissionMerger;
import java.sql.Connection;
import java.sql.SQLException;

public final class OXFolderDeleteListenerHelper {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(OXFolderDeleteListenerHelper.class));

    private OXFolderDeleteListenerHelper() {
    }

    public static void ensureConsistency(Context ctx, Connection writeCon) throws OXException {
        try {
            OXFolderDeleteListenerHelper.checkUserPermissions(ctx.getContextId(), writeCon);
            OXFolderDeleteListenerHelper.checkGroupPermissions(ctx.getContextId(), writeCon);
        }
        catch (SQLException e) {
            throw DeleteFailedExceptionCodes.SQL_ERROR.create(e, e.getMessage());
        }
        catch (Exception e) {
            throw DeleteFailedExceptionCodes.ERROR.create(e, e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void checkUserPermissions(int cid, Connection writeCon) throws SQLException, Exception {
        CorruptPermission[] corruptPermissions = null;
        try {
            corruptPermissions = DetectCorruptPermissions.detectCorruptUserPermissions(cid, writeCon);
        }
        catch (SQLException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        if (null != corruptPermissions && corruptPermissions.length > 0) {
            boolean performTransaction;
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)new StringBuilder(64).append(corruptPermissions.length).append(" corrupt user permissions detected").toString());
            }
            if (performTransaction = writeCon.getAutoCommit()) {
                writeCon.setAutoCommit(false);
            }
            try {
                UserPermissionMerger.handleCorruptUserPermissions(corruptPermissions, writeCon);
                if (!performTransaction) return;
                writeCon.commit();
                return;
            }
            catch (SQLException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                if (!performTransaction) throw e;
                writeCon.rollback();
                throw e;
            }
            catch (Throwable t) {
                LOG.error((Object)t.getMessage(), t);
                if (!performTransaction) throw t instanceof Exception ? (Exception)t : new Exception(t.getMessage(), t);
                writeCon.rollback();
                throw t instanceof Exception ? (Exception)t : new Exception(t.getMessage(), t);
            }
            finally {
                if (performTransaction) {
                    writeCon.setAutoCommit(true);
                }
            }
        } else {
            if (!LOG.isInfoEnabled()) return;
            LOG.info((Object)new StringBuilder(64).append("No corrupt user permissions detected").toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void checkGroupPermissions(int cid, Connection writeCon) throws SQLException, Exception {
        CorruptPermission[] corruptPermissions = null;
        try {
            corruptPermissions = DetectCorruptPermissions.detectCorruptGroupPermissions(cid, writeCon);
        }
        catch (SQLException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        if (null != corruptPermissions && corruptPermissions.length > 0) {
            boolean performTransaction;
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)new StringBuilder(64).append(corruptPermissions.length).append(" corrupt group permissions detected on host ").toString());
            }
            if (performTransaction = writeCon.getAutoCommit()) {
                writeCon.setAutoCommit(false);
            }
            try {
                GroupPermissionMerger.handleCorruptGroupPermissions(corruptPermissions, writeCon);
                if (!performTransaction) return;
                writeCon.commit();
                return;
            }
            catch (SQLException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                if (!performTransaction) throw e;
                writeCon.rollback();
                throw e;
            }
            catch (Throwable t) {
                LOG.error((Object)t.getMessage(), t);
                if (!performTransaction) throw t instanceof Exception ? (Exception)t : new Exception(t.getMessage(), t);
                writeCon.rollback();
                throw t instanceof Exception ? (Exception)t : new Exception(t.getMessage(), t);
            }
            finally {
                if (performTransaction) {
                    writeCon.setAutoCommit(true);
                }
            }
        } else {
            if (!LOG.isInfoEnabled()) return;
            LOG.info((Object)new StringBuilder(64).append("No corrupt group permissions detected on host ").toString());
        }
    }
}

