/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.io;

import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;

public final class IOUtils {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(IOUtils.class));

    private IOUtils() {
    }

    public static void closeStuff(Closeable closeable) {
        if (null != closeable) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void closeStreamStuff(InputStream input) {
        IOUtils.closeStuff(input);
    }

    public static void closeReaderStuff(Reader reader) {
        IOUtils.closeStuff(reader);
    }

    public static void transfer(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[4096];
        int length = -1;
        while ((length = in.read(buffer)) > 0) {
            out.write(buffer, 0, length);
        }
        out.flush();
    }
}

