/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.images.transformations;

import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.images.impl.ImageInformation;
import com.openexchange.tools.images.transformations.ImageTransformation;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.io.IOException;

public class CropTransformation
implements ImageTransformation {
    private static org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(CropTransformation.class));
    private final int x;
    private final int y;
    private final int width;
    private final int height;

    public CropTransformation(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    @Override
    public BufferedImage perform(BufferedImage sourceImage, ImageInformation imageInformation) throws IOException {
        BufferedImage targetImage = null;
        if (0 <= this.x && sourceImage.getWidth() > this.x && sourceImage.getWidth() >= this.x + this.width && 0 <= this.y && sourceImage.getHeight() > this.y && sourceImage.getHeight() >= this.y + this.height) {
            targetImage = sourceImage.getSubimage(this.x, this.y, this.width, this.height);
        } else {
            try {
                targetImage = new BufferedImage(this.width, this.height, sourceImage.getType(), (IndexColorModel)sourceImage.getColorModel());
            }
            catch (ClassCastException e) {
                LOG.debug((Object)"Can't reuse source image's color model, falling back to defaults.", (Throwable)e);
                targetImage = new BufferedImage(this.width, this.height, sourceImage.getType());
            }
            Graphics2D graphics = targetImage.createGraphics();
            graphics.setBackground(new Color(255, 255, 255, 0));
            graphics.clearRect(0, 0, this.width, this.height);
            graphics.drawImage((Image)sourceImage, this.x, this.y, null);
        }
        return targetImage;
    }

    @Override
    public boolean needsImageInformation() {
        return false;
    }

    @Override
    public boolean supports(String formatName) {
        return true;
    }
}

