/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class FIFOQueue<T> {
    private final T[] array;
    private int start;
    private int end;
    private boolean full;
    private final Lock r;
    private final Lock w;
    private final boolean isSynchronized;

    public FIFOQueue(int maxsize) {
        this(maxsize, true);
    }

    public FIFOQueue(int maxsize, boolean isSynchronized) {
        Object[] ts = new Object[maxsize];
        this.array = ts;
        this.end = 0;
        this.start = 0;
        this.full = false;
        this.isSynchronized = isSynchronized;
        if (isSynchronized) {
            ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
            this.r = rwLock.readLock();
            this.w = rwLock.writeLock();
        } else {
            this.r = null;
            this.w = null;
        }
    }

    private void acquireReadLock() {
        if (this.isSynchronized) {
            this.r.lock();
        }
    }

    private void releaseReadLock() {
        if (this.isSynchronized) {
            this.r.unlock();
        }
    }

    private void acquireWriteLock() {
        if (this.isSynchronized) {
            this.w.lock();
        }
    }

    private void releaseWriteLock() {
        if (this.isSynchronized) {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        this.acquireReadLock();
        try {
            boolean bl = this.isEmpty0();
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    private boolean isEmpty0() {
        return this.start == this.end && !this.full;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFull() {
        this.acquireReadLock();
        try {
            boolean bl = this.full;
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        this.acquireReadLock();
        try {
            if (this.full) {
                int n = this.array.length;
                return n;
            }
            if (this.isEmpty0()) {
                int n = 0;
                return n;
            }
            int n = this.start - this.end;
            return n;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(T obj) {
        this.acquireWriteLock();
        try {
            if (!this.full) {
                ++this.start;
                this.array[this.start %= this.array.length] = obj;
            }
            if (this.start == this.end) {
                this.full = true;
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T dequeue() {
        this.acquireWriteLock();
        try {
            if (this.full) {
                this.full = false;
            } else if (this.isEmpty0()) {
                T t = null;
                return t;
            }
            ++this.end;
            T retval = this.array[this.end %= this.array.length];
            this.array[this.end] = null;
            T t = retval;
            return t;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        this.acquireReadLock();
        try {
            if (this.isEmpty0()) {
                T t = null;
                return t;
            }
            int tmp = this.end++;
            T retval = this.array[this.end %= this.array.length];
            this.end = tmp;
            T t = retval;
            return t;
        }
        finally {
            this.releaseReadLock();
        }
    }
}

