/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.pooling;

import java.util.concurrent.atomic.AtomicInteger;

public class PooledData<T> {
    private static final AtomicInteger counter = new AtomicInteger();
    private final int identifier;
    private final long createTime = System.currentTimeMillis();
    private long timestamp;
    private final T pooled;
    private Thread thread;
    private StackTraceElement[] trace;

    PooledData(T pooled) {
        this.touch();
        this.identifier = counter.incrementAndGet();
        this.pooled = pooled;
    }

    void setThread(Thread user) {
        this.thread = user;
    }

    final void touch() {
        this.timestamp = System.currentTimeMillis();
    }

    public T getPooled() {
        return this.pooled;
    }

    void setTrace(StackTraceElement[] trace) {
        this.trace = trace;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PooledData)) {
            return false;
        }
        return this.pooled.equals(((PooledData)obj).pooled);
    }

    public int hashCode() {
        return this.pooled.hashCode();
    }

    void resetTrace() {
        this.thread = null;
        this.trace = null;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getTimeDiff() {
        return System.currentTimeMillis() - this.timestamp;
    }

    public long getLiveTime() {
        return System.currentTimeMillis() - this.createTime;
    }

    Thread getThread() {
        return this.thread;
    }

    public StackTraceElement[] getTrace() {
        return this.trace;
    }

    public int getIdentifier() {
        return this.identifier;
    }
}

